/*
 * Decompiled with CFR 0.152.
 */
package ui;

import db.DatabaseConnection;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import persistance.Consumer;
import persistance.Producer;
import ui.EnergeticCommunitiesSimulator;

public class KeyConfiguration {
    private static final String configFile = "config.ini";
    private static Locale currentLocale;
    private static ResourceBundle messages;
    private Shell shell;
    private static int width;
    private static int height;
    private static Iterator<Consumer> itConsumers;
    private static Iterator<Producer> itProducers;
    private final Table tableKeyConsumers;
    private final Table tableKeyProducers;
    private static TableItem tableItem;

    static {
        width = 750;
        height = 250;
    }

    public KeyConfiguration(Shell mainShell, final ArrayList<Consumer> consumers, final Tree treeConsumers, final ArrayList<Producer> producers, final Tree treeProducers, final Button btnCompute, final Button btnExportResults) {
        String language = "en";
        try {
            FileReader reader = new FileReader(configFile);
            JSONParser jsonParser = new JSONParser();
            JSONObject configObject = (JSONObject)jsonParser.parse((Reader)reader);
            language = (String)configObject.get((Object)"language");
        }
        catch (Exception reader) {
            // empty catch block
        }
        currentLocale = new Locale(language, "");
        messages = ResourceBundle.getBundle("languages", currentLocale);
        this.shell = new Shell(mainShell, 65536);
        this.shell.setSize(width, height);
        this.shell.setLayout((Layout)new GridLayout(4, false));
        Label lblConsumers = new Label((Composite)this.shell, 0);
        lblConsumers.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
        lblConsumers.setText(messages.getString("consumers"));
        Label lblProducers = new Label((Composite)this.shell, 0);
        lblProducers.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
        lblProducers.setText(messages.getString("producers"));
        this.tableKeyConsumers = new Table((Composite)this.shell, 67584);
        GridData gdTableConsumers = new GridData(16384, 4, true, true, 2, 1);
        gdTableConsumers.minimumWidth = 250;
        gdTableConsumers.widthHint = 424;
        this.tableKeyConsumers.setLayoutData((Object)gdTableConsumers);
        this.tableKeyConsumers.setHeaderVisible(true);
        this.tableKeyConsumers.setLinesVisible(true);
        TableColumn tableConsumersClmnName = new TableColumn(this.tableKeyConsumers, 0);
        tableConsumersClmnName.setWidth(165);
        tableConsumersClmnName.setResizable(false);
        tableConsumersClmnName.setText(messages.getString("name"));
        TableColumn tableConsumersClmnPriority = new TableColumn(this.tableKeyConsumers, 0x1000000);
        tableConsumersClmnPriority.setWidth(80);
        tableConsumersClmnPriority.setResizable(false);
        tableConsumersClmnPriority.setText(messages.getString("priority"));
        TableColumn tableConsumersClmnPercentage = new TableColumn(this.tableKeyConsumers, 0x1000000);
        tableConsumersClmnPercentage.setWidth(95);
        tableConsumersClmnPercentage.setResizable(false);
        tableConsumersClmnPercentage.setText(messages.getString("percentage"));
        TableColumn tableConsumersClmnProrata = new TableColumn(this.tableKeyConsumers, 0x1000000);
        tableConsumersClmnProrata.setWidth(80);
        tableConsumersClmnProrata.setResizable(false);
        tableConsumersClmnProrata.setText(messages.getString("prorata"));
        for (Consumer consumer : consumers) {
            tableItem = new TableItem(this.tableKeyConsumers, 0);
            tableItem.setText(0, consumer.getName());
            TableEditor editor = new TableEditor(this.tableKeyConsumers);
            Text textPriority = new Text((Composite)this.tableKeyConsumers, 0x1000000);
            int priority = consumer.getPriority();
            if (priority == 0) {
                textPriority.setText("");
            } else {
                textPriority.setText("" + priority);
            }
            textPriority.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent e) {
                    Text text = (Text)e.getSource();
                    String oldS = text.getText();
                    String newS = String.valueOf(oldS.substring(0, e.start)) + e.text + oldS.substring(e.end);
                    if (newS != "") {
                        try {
                            Integer.parseInt(newS);
                        }
                        catch (NumberFormatException exception) {
                            e.doit = false;
                        }
                    }
                    if (newS.equals("0")) {
                        e.doit = false;
                    }
                }
            });
            textPriority.addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent e) {
                    Text textPriority = (Text)e.getSource();
                    Button prorataButton = null;
                    if (!textPriority.getText().isEmpty()) {
                        boolean found = false;
                        int i = 0;
                        while (!found && i < KeyConfiguration.this.tableKeyConsumers.getItemCount()) {
                            KeyConfiguration.tableItem = KeyConfiguration.this.tableKeyConsumers.getItem(i);
                            if (tableItem.getData("priority") == textPriority) {
                                prorataButton = (Button)tableItem.getData("prorata");
                                String percentage = ((Text)tableItem.getData("percentage")).getText();
                                if (!percentage.isEmpty()) {
                                    MessageBox errorMessageBox = new MessageBox(KeyConfiguration.this.shell, 33);
                                    errorMessageBox.setMessage(messages.getString("errorPercentageDefined"));
                                    errorMessageBox.open();
                                    ((Text)e.getSource()).setText("");
                                }
                                found = true;
                            }
                            ++i;
                        }
                    } else {
                        boolean found = false;
                        int i = 0;
                        while (!found && i < KeyConfiguration.this.tableKeyConsumers.getItemCount()) {
                            KeyConfiguration.tableItem = KeyConfiguration.this.tableKeyConsumers.getItem(i);
                            if (tableItem.getData("priority") == textPriority) {
                                prorataButton = (Button)tableItem.getData("prorata");
                                prorataButton.setSelection(true);
                                found = true;
                            }
                            ++i;
                        }
                    }
                }

                public void focusGained(FocusEvent e) {
                }
            });
            textPriority.pack();
            editor.grabHorizontal = true;
            editor.setEditor((Control)textPriority, tableItem, 1);
            tableItem.setData("priority", (Object)textPriority);
            editor = new TableEditor(this.tableKeyConsumers);
            Text textPercentage = new Text((Composite)this.tableKeyConsumers, 0x1000000);
            int percentage = consumer.getPercentage();
            if (percentage == 0) {
                textPercentage.setText("");
            } else {
                textPercentage.setText("" + percentage);
            }
            textPercentage.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent e) {
                    Text text = (Text)e.getSource();
                    String oldS = text.getText();
                    String newS = String.valueOf(oldS.substring(0, e.start)) + e.text + oldS.substring(e.end);
                    if (newS != "") {
                        try {
                            Integer.parseInt(newS);
                        }
                        catch (NumberFormatException exception) {
                            e.doit = false;
                        }
                    }
                    if (newS.equals("0")) {
                        e.doit = false;
                    }
                }
            });
            textPercentage.addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent e) {
                    Text textPercentage = (Text)e.getSource();
                    Button prorataButton = null;
                    if (!textPercentage.getText().isEmpty()) {
                        boolean found = false;
                        int i = 0;
                        while (!found && i < KeyConfiguration.this.tableKeyConsumers.getItemCount()) {
                            KeyConfiguration.tableItem = KeyConfiguration.this.tableKeyConsumers.getItem(i);
                            if (tableItem.getData("percentage") == textPercentage) {
                                prorataButton = (Button)tableItem.getData("prorata");
                                String priority = ((Text)tableItem.getData("priority")).getText();
                                if (!priority.isEmpty()) {
                                    MessageBox errorMessageBox = new MessageBox(KeyConfiguration.this.shell, 33);
                                    errorMessageBox.setMessage(messages.getString("errorPriorityDefined"));
                                    errorMessageBox.open();
                                    ((Text)e.getSource()).setText("");
                                } else {
                                    int percentage = 0;
                                    i = 0;
                                    while (i < KeyConfiguration.this.tableKeyConsumers.getItemCount()) {
                                        KeyConfiguration.tableItem = KeyConfiguration.this.tableKeyConsumers.getItem(i);
                                        try {
                                            percentage += Integer.parseInt(((Text)tableItem.getData("percentage")).getText());
                                        }
                                        catch (NumberFormatException numberFormatException) {
                                            // empty catch block
                                        }
                                        ++i;
                                    }
                                    if (percentage > 100) {
                                        MessageBox errorMessageBox = new MessageBox(KeyConfiguration.this.shell, 33);
                                        errorMessageBox.setMessage(messages.getString("errorPercentageOver100"));
                                        errorMessageBox.open();
                                        ((Text)e.getSource()).setText("");
                                        prorataButton.setSelection(true);
                                    }
                                }
                                found = true;
                            }
                            ++i;
                        }
                    } else {
                        boolean found = false;
                        int i = 0;
                        while (!found && i < KeyConfiguration.this.tableKeyConsumers.getItemCount()) {
                            KeyConfiguration.tableItem = KeyConfiguration.this.tableKeyConsumers.getItem(i);
                            if (tableItem.getData("percentage") == textPercentage) {
                                prorataButton = (Button)tableItem.getData("prorata");
                                prorataButton.setSelection(true);
                                found = true;
                            }
                            ++i;
                        }
                    }
                }

                public void focusGained(FocusEvent e) {
                }
            });
            textPercentage.pack();
            editor.grabHorizontal = true;
            editor.setEditor((Control)textPercentage, tableItem, 2);
            tableItem.setData("percentage", (Object)textPercentage);
            editor = new TableEditor(this.tableKeyConsumers);
            Button checkButton = new Button((Composite)this.tableKeyConsumers, 32);
            if (consumer.getProrata() == 1) {
                checkButton.setSelection(true);
            }
            checkButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    KeyConfiguration.this.shell.forceFocus();
                    Button currentButton = (Button)e.getSource();
                    if (!currentButton.getSelection()) {
                        boolean found = false;
                        int i = 0;
                        while (!found && i < KeyConfiguration.this.tableKeyConsumers.getItemCount()) {
                            KeyConfiguration.tableItem = KeyConfiguration.this.tableKeyConsumers.getItem(i);
                            if (tableItem.getData("prorata") == currentButton) {
                                String priority = ((Text)tableItem.getData("priority")).getText();
                                String percentage = ((Text)tableItem.getData("percentage")).getText();
                                if (priority.isEmpty() && percentage.isEmpty()) {
                                    MessageBox errorMessageBox = new MessageBox(KeyConfiguration.this.shell, 33);
                                    errorMessageBox.setMessage(messages.getString("errorProrataNoPriorityNorPercentage"));
                                    errorMessageBox.open();
                                    ((Button)e.getSource()).setSelection(true);
                                }
                                found = true;
                            }
                            ++i;
                        }
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            checkButton.pack();
            editor.minimumWidth = checkButton.getSize().x;
            editor.horizontalAlignment = 0x1000000;
            editor.setEditor((Control)checkButton, tableItem, 3);
            tableItem.setData("prorata", (Object)checkButton);
        }
        this.tableKeyConsumers.pack();
        this.tableKeyProducers = new Table((Composite)this.shell, 67584);
        GridData gdTableProducers = new GridData(16384, 4, true, true, 2, 1);
        gdTableProducers.minimumWidth = 250;
        gdTableProducers.widthHint = 249;
        this.tableKeyProducers.setLayoutData((Object)gdTableProducers);
        this.tableKeyProducers.setHeaderVisible(true);
        this.tableKeyProducers.setLinesVisible(true);
        TableColumn tableProducersClmnName = new TableColumn(this.tableKeyProducers, 0);
        tableProducersClmnName.setWidth(165);
        tableProducersClmnName.setResizable(false);
        tableProducersClmnName.setText(messages.getString("name"));
        TableColumn tableProducersClmnPriority = new TableColumn(this.tableKeyProducers, 0x1000000);
        tableProducersClmnPriority.setWidth(80);
        tableProducersClmnPriority.setResizable(false);
        tableProducersClmnPriority.setText(messages.getString("priority"));
        for (Producer producer : producers) {
            tableItem = new TableItem(this.tableKeyProducers, 0);
            tableItem.setText(0, producer.getName());
            TableEditor editor = new TableEditor(this.tableKeyProducers);
            Text textPriority = new Text((Composite)this.tableKeyProducers, 0x1000000);
            int priority = producer.getPriority();
            if (priority == 0) {
                textPriority.setText("");
            } else {
                textPriority.setText("" + priority);
            }
            textPriority.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent e) {
                    Text text = (Text)e.getSource();
                    String oldS = text.getText();
                    String newS = String.valueOf(oldS.substring(0, e.start)) + e.text + oldS.substring(e.end);
                    if (newS != "") {
                        try {
                            Integer.parseInt(newS);
                        }
                        catch (NumberFormatException exception) {
                            e.doit = false;
                        }
                    }
                }
            });
            textPriority.pack();
            editor.grabHorizontal = true;
            editor.setEditor((Control)textPriority, tableItem, 1);
            tableItem.setData("priority", (Object)textPriority);
        }
        this.tableKeyProducers.pack();
        new Label((Composite)this.shell, 0);
        new Label((Composite)this.shell, 0);
        Button btnCancel = new Button((Composite)this.shell, 0);
        btnCancel.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 1, 1));
        btnCancel.setText(messages.getString("cancel"));
        btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                KeyConfiguration.this.shell.dispose();
            }
        });
        Button btnValidate = new Button((Composite)this.shell, 0);
        btnValidate.setText(messages.getString("ok"));
        btnValidate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean error = false;
                int percentage = 0;
                int i = 0;
                while (i < KeyConfiguration.this.tableKeyConsumers.getItemCount()) {
                    KeyConfiguration.tableItem = KeyConfiguration.this.tableKeyConsumers.getItem(i);
                    String sPriority = ((Text)tableItem.getData("priority")).getText();
                    String sPercentage = ((Text)tableItem.getData("percentage")).getText();
                    boolean sProrata = ((Button)tableItem.getData("prorata")).getSelection();
                    if (sPriority.isEmpty() && sPercentage.isEmpty() && !sProrata) {
                        error = true;
                        System.out.println("ERROR");
                    }
                    try {
                        percentage += Integer.parseInt(((Text)tableItem.getData("percentage")).getText());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    ++i;
                }
                if (percentage > 100) {
                    error = true;
                }
                if (error) {
                    KeyConfiguration.this.shell.forceFocus();
                } else {
                    Producer producer;
                    int cPriority;
                    String iPriority;
                    Consumer consumer;
                    i = 0;
                    itConsumers = consumers.iterator();
                    while (itConsumers.hasNext()) {
                        consumer = (Consumer)itConsumers.next();
                        KeyConfiguration.tableItem = KeyConfiguration.this.tableKeyConsumers.getItem(i);
                        iPriority = ((Text)tableItem.getData("priority")).getText();
                        cPriority = 0;
                        if (!iPriority.isEmpty()) {
                            cPriority = Integer.parseInt(iPriority);
                        }
                        String iPercentage = ((Text)tableItem.getData("percentage")).getText();
                        int cPercentage = 0;
                        if (!iPercentage.isEmpty()) {
                            cPercentage = Integer.parseInt(iPercentage);
                        }
                        int cProrata = ((Button)tableItem.getData("prorata")).getSelection() ? 1 : 0;
                        consumer.setPriority(cPriority);
                        consumer.setPercentage(cPercentage);
                        consumer.setProrata(cProrata);
                        DatabaseConnection.updateConsumer(consumer);
                        ++i;
                    }
                    i = 0;
                    itProducers = producers.iterator();
                    while (itProducers.hasNext()) {
                        producer = (Producer)itProducers.next();
                        KeyConfiguration.tableItem = KeyConfiguration.this.tableKeyProducers.getItem(i);
                        iPriority = ((Text)tableItem.getData("priority")).getText();
                        cPriority = 0;
                        if (!iPriority.isEmpty()) {
                            cPriority = Integer.parseInt(iPriority);
                        }
                        producer.setPriority(cPriority);
                        DatabaseConnection.updateProducer(producer);
                        ++i;
                    }
                    DatabaseConnection.deleteComputation();
                    i = 0;
                    itConsumers = consumers.iterator();
                    while (itConsumers.hasNext()) {
                        consumer = (Consumer)itConsumers.next();
                        TreeItem treeItemConsumer = treeConsumers.getItem(i);
                        treeItemConsumer.getItem(2).setText(String.valueOf(messages.getString("priority")) + ": " + (consumer.getPriority() == 0 ? "\ufffd" : Integer.valueOf(consumer.getPriority())));
                        treeItemConsumer.getItem(3).setText(String.valueOf(messages.getString("percentage")) + ": " + (consumer.getPercentage() == 0 ? "\ufffd" : Integer.valueOf(consumer.getPercentage())));
                        treeItemConsumer.getItem(4).setText(String.valueOf(messages.getString("prorata")) + ": " + (consumer.getProrata() == 0 ? messages.getString("disabled") : messages.getString("enabled")));
                        ++i;
                    }
                    i = 0;
                    itProducers = producers.iterator();
                    while (itProducers.hasNext()) {
                        producer = (Producer)itProducers.next();
                        TreeItem treeItemProducer = treeProducers.getItem(i);
                        treeItemProducer.getItem(2).setText(String.valueOf(messages.getString("priority")) + ": " + (producer.getPriority() == 0 ? "\ufffd" : Integer.valueOf(producer.getPriority())));
                        ++i;
                    }
                    EnergeticCommunitiesSimulator.updateTables();
                    EnergeticCommunitiesSimulator.updateChart();
                    btnCompute.setEnabled(true);
                    btnExportResults.setEnabled(DatabaseConnection.computationHasBeenPerformed());
                    KeyConfiguration.this.shell.dispose();
                }
            }
        });
        this.shell.pack();
    }

    public void open() {
        this.shell.open();
    }

    public void close() {
        this.shell.setVisible(false);
    }
}

