/*
 * Decompiled with CFR 0.152.
 */
package ui;

import computation.ComputeSharing;
import db.DatabaseConnection;
import exportation.Export;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.Reader;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swtchart.Chart;
import org.eclipse.swtchart.IAxis;
import org.eclipse.swtchart.IAxisTick;
import org.eclipse.swtchart.ILegend;
import org.eclipse.swtchart.ILineSeries;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.LineStyle;
import org.eclipse.swtchart.Range;
import org.eclipse.wb.swt.SWTResourceManager;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import persistance.Consumer;
import persistance.Producer;
import ui.AddConsumer;
import ui.AddProducer;
import ui.CustomMessageBox;
import ui.KeyConfiguration;

public class EnergeticCommunitiesSimulator {
    protected static Display display;
    protected static Shell shell;
    private static Locale currentLocale;
    private static ResourceBundle messages;
    private static final String configFile = "config.ini";
    private static final String version = "1.05";
    private static DecimalFormat format;
    private static DateFormat dateFormat;
    private static DateTimeFormatter dateFormatter;
    protected static Table tableConsumers;
    protected static Table tableProducers;
    protected ProgressBar progressBar;
    private Button btnCompute;
    private Button btnKeyConfiguration;
    private Button btnExportResults;
    protected Tree treeConsumers;
    protected Tree treeProducers;
    private static TableItem tableItem;
    private static Composite containerChart;
    private static Chart chart;
    protected static ArrayList<Consumer> consumers;
    private static Iterator<Consumer> itConsumers;
    protected static ArrayList<Producer> producers;
    private static Iterator<Producer> itProducers;
    private static Map<String, Boolean> showAllLines;
    private static Map<String, Boolean> showLinesTotalEnergy;
    private static Map<String, Boolean> showLinesCommunityEnergy;
    private static Map<String, Boolean> showLinesNetworkEnergy;
    protected static LocalDate currentStartDate;
    private static LocalDate currentEndDate;
    private static Label lblStartDate;
    private static Label lblEndDate;

    static {
        showAllLines = new TreeMap<String, Boolean>();
        showLinesTotalEnergy = new TreeMap<String, Boolean>();
        showLinesCommunityEnergy = new TreeMap<String, Boolean>();
        showLinesNetworkEnergy = new TreeMap<String, Boolean>();
    }

    public static void main(String[] args) throws Exception {
        DatabaseConnection.connect();
        consumers = DatabaseConnection.getAllConsumers();
        producers = DatabaseConnection.getAllProducers();
        for (Consumer consumer : consumers) {
            showAllLines.put(consumer.getPodNumber(), false);
            showLinesTotalEnergy.put(consumer.getPodNumber(), false);
            showLinesCommunityEnergy.put(consumer.getPodNumber(), false);
            showLinesNetworkEnergy.put(consumer.getPodNumber(), false);
        }
        for (Producer producer : producers) {
            showAllLines.put(producer.getPodNumber(), false);
            showLinesTotalEnergy.put(producer.getPodNumber(), false);
            showLinesCommunityEnergy.put(producer.getPodNumber(), false);
            showLinesNetworkEnergy.put(producer.getPodNumber(), false);
        }
        String language = "en";
        try {
            FileReader reader = new FileReader(configFile);
            JSONParser jsonParser = new JSONParser();
            JSONObject configObject = (JSONObject)jsonParser.parse((Reader)reader);
            language = (String)configObject.get((Object)"language");
        }
        catch (Exception reader) {
            // empty catch block
        }
        currentLocale = new Locale(language, "");
        messages = ResourceBundle.getBundle("languages", currentLocale);
        format = new DecimalFormat("###,##0.00");
        DecimalFormatSymbols s = format.getDecimalFormatSymbols();
        s.setGroupingSeparator(' ');
        s.setDecimalSeparator(',');
        format.setDecimalFormatSymbols(s);
        try {
            EnergeticCommunitiesSimulator window = new EnergeticCommunitiesSimulator();
            window.open();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DatabaseConnection.close();
    }

    public void open() {
        Display.setAppName((String)messages.getString("shortnameapp"));
        display = Display.getDefault();
        this.createContents();
        shell.open();
        shell.layout();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    protected void createContents() {
        dateFormat = currentLocale.getLanguage().equals("en") ? new SimpleDateFormat("dd-MM-yyyy") : new SimpleDateFormat("dd-MM-yyyy");
        dateFormatter = DateTimeFormatter.ofPattern("dd/MM/yyyy");
        shell = new Shell();
        shell.setMinimumSize(new Point(1200, 980));
        shell.setSize(1413, 980);
        shell.setText(String.valueOf(messages.getString("nameapp")) + " v." + version);
        shell.setImage(new Image((Device)display, ClassLoader.getSystemClassLoader().getResourceAsStream("favicon.ico")));
        shell.setLayout((Layout)new GridLayout(3, false));
        Menu menuBar = new Menu((Decorations)shell, 2);
        shell.setMenuBar(menuBar);
        MenuItem mntmFile = new MenuItem(menuBar, 64);
        mntmFile.setText(messages.getString("file"));
        Menu menuFileEntries = new Menu(mntmFile);
        mntmFile.setMenu(menuFileEntries);
        MenuItem mntmLanguage = new MenuItem(menuFileEntries, 64);
        mntmLanguage.setText(messages.getString("language"));
        Menu menuLanguage = new Menu(mntmLanguage);
        mntmLanguage.setMenu(menuLanguage);
        final MenuItem mntmEnglish = new MenuItem(menuLanguage, 16);
        mntmEnglish.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (mntmEnglish.getSelection()) {
                    int result = 0;
                    CustomMessageBox mbConfirmDialog = new CustomMessageBox(shell, CustomMessageBox.ImageCode.WARNING, messages.getString("titleConfirmLanguage"), messages.getString("messageConfirmLanguage"));
                    mbConfirmDialog.addButton(messages.getString("no"), 0);
                    mbConfirmDialog.addButton(messages.getString("yes"), 1, true);
                    result = mbConfirmDialog.getResult();
                    if (result == 1) {
                        currentLocale = new Locale("en", "");
                        messages = ResourceBundle.getBundle("languages", currentLocale);
                        try {
                            FileReader reader = new FileReader(EnergeticCommunitiesSimulator.configFile);
                            JSONParser jsonParser = new JSONParser();
                            JSONObject config = (JSONObject)jsonParser.parse((Reader)reader);
                            config.put((Object)"language", (Object)currentLocale.getLanguage());
                            File file = new File(EnergeticCommunitiesSimulator.configFile);
                            DataOutputStream outstream = new DataOutputStream(new FileOutputStream(file, false));
                            outstream.write(config.toJSONString().getBytes());
                            outstream.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        shell.close();
                        EnergeticCommunitiesSimulator.this.createContents();
                        shell.open();
                        shell.layout();
                    }
                }
            }
        });
        mntmEnglish.setText(messages.getString("english"));
        if (currentLocale.getLanguage() == "en") {
            mntmEnglish.setSelection(true);
        }
        final MenuItem mntmFrench = new MenuItem(menuLanguage, 16);
        mntmFrench.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (mntmFrench.getSelection()) {
                    int result = 0;
                    CustomMessageBox mbConfirmDialog = new CustomMessageBox(shell, CustomMessageBox.ImageCode.WARNING, messages.getString("titleConfirmLanguage"), messages.getString("messageConfirmLanguage"));
                    mbConfirmDialog.addButton(messages.getString("no"), 0);
                    mbConfirmDialog.addButton(messages.getString("yes"), 1, true);
                    result = mbConfirmDialog.getResult();
                    if (result == 1) {
                        currentLocale = new Locale("fr", "");
                        messages = ResourceBundle.getBundle("languages", currentLocale);
                        try {
                            FileReader reader = new FileReader(EnergeticCommunitiesSimulator.configFile);
                            JSONParser jsonParser = new JSONParser();
                            JSONObject config = (JSONObject)jsonParser.parse((Reader)reader);
                            config.put((Object)"language", (Object)currentLocale.getLanguage());
                            File file = new File(EnergeticCommunitiesSimulator.configFile);
                            DataOutputStream outstream = new DataOutputStream(new FileOutputStream(file, false));
                            outstream.write(config.toJSONString().getBytes());
                            outstream.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        shell.close();
                        EnergeticCommunitiesSimulator.this.createContents();
                        shell.open();
                        shell.layout();
                    }
                }
            }
        });
        mntmFrench.setText(messages.getString("french"));
        if (currentLocale.getLanguage() == "fr") {
            mntmFrench.setSelection(true);
        }
        final MenuItem mntmGerman = new MenuItem(menuLanguage, 16);
        mntmGerman.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (mntmGerman.getSelection()) {
                    int result = 0;
                    CustomMessageBox mbConfirmDialog = new CustomMessageBox(shell, CustomMessageBox.ImageCode.WARNING, messages.getString("titleConfirmLanguage"), messages.getString("messageConfirmLanguage"));
                    mbConfirmDialog.addButton(messages.getString("no"), 0);
                    mbConfirmDialog.addButton(messages.getString("yes"), 1, true);
                    result = mbConfirmDialog.getResult();
                    if (result == 1) {
                        currentLocale = new Locale("de", "");
                        messages = ResourceBundle.getBundle("languages", currentLocale);
                        try {
                            FileReader reader = new FileReader(EnergeticCommunitiesSimulator.configFile);
                            JSONParser jsonParser = new JSONParser();
                            JSONObject config = (JSONObject)jsonParser.parse((Reader)reader);
                            config.put((Object)"language", (Object)currentLocale.getLanguage());
                            File file = new File(EnergeticCommunitiesSimulator.configFile);
                            DataOutputStream outstream = new DataOutputStream(new FileOutputStream(file, false));
                            outstream.write(config.toJSONString().getBytes());
                            outstream.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        shell.close();
                        EnergeticCommunitiesSimulator.this.createContents();
                        shell.open();
                        shell.layout();
                    }
                }
            }
        });
        mntmGerman.setText(messages.getString("german"));
        if (currentLocale.getLanguage() == "de") {
            mntmGerman.setSelection(true);
        }
        final MenuItem mntmLuxembourgish = new MenuItem(menuLanguage, 16);
        mntmLuxembourgish.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (mntmLuxembourgish.getSelection()) {
                    int result = 0;
                    CustomMessageBox mbConfirmDialog = new CustomMessageBox(shell, CustomMessageBox.ImageCode.WARNING, messages.getString("titleConfirmLanguage"), messages.getString("messageConfirmLanguage"));
                    mbConfirmDialog.addButton(messages.getString("no"), 0);
                    mbConfirmDialog.addButton(messages.getString("yes"), 1, true);
                    result = mbConfirmDialog.getResult();
                    if (result == 1) {
                        currentLocale = new Locale("lu", "");
                        messages = ResourceBundle.getBundle("languages", currentLocale);
                        try {
                            FileReader reader = new FileReader(EnergeticCommunitiesSimulator.configFile);
                            JSONParser jsonParser = new JSONParser();
                            JSONObject config = (JSONObject)jsonParser.parse((Reader)reader);
                            config.put((Object)"language", (Object)currentLocale.getLanguage());
                            File file = new File(EnergeticCommunitiesSimulator.configFile);
                            DataOutputStream outstream = new DataOutputStream(new FileOutputStream(file, false));
                            outstream.write(config.toJSONString().getBytes());
                            outstream.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        shell.close();
                        EnergeticCommunitiesSimulator.this.createContents();
                        shell.open();
                        shell.layout();
                    }
                }
            }
        });
        mntmLuxembourgish.setText(messages.getString("luxembourgish"));
        if (currentLocale.getLanguage() == "lu") {
            mntmLuxembourgish.setSelection(true);
        }
        new MenuItem(menuFileEntries, 2);
        MenuItem mntmReset = new MenuItem(menuFileEntries, 0);
        mntmReset.setText(String.valueOf(messages.getString("reset")) + "\tCTRL + R");
        mntmReset.setAccelerator(262226);
        mntmReset.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int result = 0;
                CustomMessageBox mbConfirmDialog = new CustomMessageBox(shell, CustomMessageBox.ImageCode.WARNING, messages.getString("titleConfirmReset"), messages.getString("messageConfirmReset"));
                mbConfirmDialog.addButton(messages.getString("no"), 0);
                mbConfirmDialog.addButton(messages.getString("yes"), 1, true);
                result = mbConfirmDialog.getResult();
                if (result == 1) {
                    Control control;
                    DatabaseConnection.truncateConsumptionData();
                    DatabaseConnection.truncateProductionData();
                    DatabaseConnection.truncateConsumptionDataAfterSharing();
                    DatabaseConnection.truncateProductionDataAfterSharing();
                    DatabaseConnection.removeAllConsumers();
                    DatabaseConnection.removeAllProducers();
                    DatabaseConnection.resetUsedColors();
                    consumers.clear();
                    producers.clear();
                    EnergeticCommunitiesSimulator.this.treeConsumers.removeAll();
                    EnergeticCommunitiesSimulator.this.treeProducers.removeAll();
                    tableConsumers.removeAll();
                    Control[] controlArray = tableConsumers.getChildren();
                    int n = controlArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        control = controlArray[n2];
                        if (control instanceof Button) {
                            control.dispose();
                        }
                        ++n2;
                    }
                    EnergeticCommunitiesSimulator.tableItem = new TableItem(tableConsumers, 0);
                    tableItem.setText(1, messages.getString("TOTAL"));
                    tableItem.setText(2, format.format(0.0));
                    tableProducers.removeAll();
                    controlArray = tableProducers.getChildren();
                    n = controlArray.length;
                    n2 = 0;
                    while (n2 < n) {
                        control = controlArray[n2];
                        if (control instanceof Button) {
                            control.dispose();
                        }
                        ++n2;
                    }
                    EnergeticCommunitiesSimulator.tableItem = new TableItem(tableProducers, 0);
                    tableItem.setText(1, messages.getString("TOTAL"));
                    tableItem.setText(2, format.format(0.0));
                    EnergeticCommunitiesSimulator.this.btnCompute.setEnabled(DatabaseConnection.computationCanBePerformed());
                    EnergeticCommunitiesSimulator.this.btnKeyConfiguration.setEnabled(DatabaseConnection.consumerAndProducerDefined());
                    EnergeticCommunitiesSimulator.this.btnExportResults.setEnabled(false);
                    currentStartDate = DatabaseConnection.getOldestStartDate().toLocalDate();
                    currentEndDate = DatabaseConnection.getLatestEndDate().toLocalDate();
                    lblStartDate.setText(currentStartDate.format(dateFormatter));
                    lblEndDate.setText(currentEndDate.format(dateFormatter));
                    EnergeticCommunitiesSimulator.updateChart();
                }
            }
        });
        new MenuItem(menuFileEntries, 2);
        MenuItem mntmAbout = new MenuItem(menuFileEntries, 8);
        mntmAbout.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MessageBox mbDialog = new MessageBox(shell, 34);
                mbDialog.setText(messages.getString("titleAbout"));
                mbDialog.setMessage(messages.getString("messageAbout"));
                mbDialog.open();
            }
        });
        mntmAbout.setText(messages.getString("about"));
        new MenuItem(menuFileEntries, 2);
        MenuItem mntmClose = new MenuItem(menuFileEntries, 0);
        mntmClose.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                System.exit(0);
            }
        });
        mntmClose.setText(messages.getString("quit"));
        Composite composite = new Composite((Composite)shell, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 1, 1));
        Label logoPlaceholder = new Label(composite, 16384);
        logoPlaceholder.setAlignment(131072);
        logoPlaceholder.setImage(new Image((Device)display, ClassLoader.getSystemClassLoader().getResourceAsStream("logo.png")));
        Label vSeparator = new Label((Composite)shell, 514);
        GridData gd_vSeparator = new GridData(4, 4, false, false, 1, 9);
        gd_vSeparator.heightHint = 910;
        vSeparator.setLayoutData((Object)gd_vSeparator);
        containerChart = new Composite((Composite)shell, 0);
        containerChart.setLayout((Layout)new FillLayout(256));
        containerChart.setLayoutData((Object)new GridData(4, 4, true, true, 1, 2));
        Composite compConsumers = new Composite((Composite)shell, 0);
        compConsumers.setLayout((Layout)new GridLayout(2, false));
        GridData gd_compConsumers = new GridData(4, 4, false, true, 1, 1);
        gd_compConsumers.widthHint = 250;
        gd_compConsumers.minimumHeight = 250;
        compConsumers.setLayoutData((Object)gd_compConsumers);
        Label lblConsumers = new Label(compConsumers, 0);
        lblConsumers.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        lblConsumers.setText(messages.getString("consumers"));
        Button btnAddConsumer = new Button(compConsumers, 0);
        btnAddConsumer.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        btnAddConsumer.setText(messages.getString("add"));
        btnAddConsumer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddConsumer addConsumer = new AddConsumer(shell, consumers, EnergeticCommunitiesSimulator.this.treeConsumers, EnergeticCommunitiesSimulator.this.btnCompute, EnergeticCommunitiesSimulator.this.btnKeyConfiguration, EnergeticCommunitiesSimulator.this.btnExportResults, EnergeticCommunitiesSimulator.this.progressBar);
                addConsumer.open();
            }
        });
        this.treeConsumers = new Tree(compConsumers, 2048);
        this.treeConsumers.setLayoutData((Object)new GridData(4, 4, false, true, 2, 1));
        for (Consumer consumer : consumers) {
            TreeItem treeConsumerItem0 = new TreeItem(this.treeConsumers, 0);
            treeConsumerItem0.setText(consumer.getName());
            TreeItem treeConsumerItem01 = new TreeItem(treeConsumerItem0, 0);
            treeConsumerItem01.setText(String.valueOf(messages.getString("startDate")) + ": " + dateFormat.format(consumer.getStartDate()));
            TreeItem treeConsumerItem02 = new TreeItem(treeConsumerItem0, 0);
            treeConsumerItem02.setText(String.valueOf(messages.getString("endDate")) + ": " + dateFormat.format(consumer.getEndDate()));
            TreeItem treeConsumerItem03 = new TreeItem(treeConsumerItem0, 0);
            treeConsumerItem03.setText(String.valueOf(messages.getString("priority")) + ": " + (consumer.getPriority() == 0 ? "-" : Integer.valueOf(consumer.getPriority())));
            TreeItem treeConsumerItem04 = new TreeItem(treeConsumerItem0, 0);
            treeConsumerItem04.setText(String.valueOf(messages.getString("percentage")) + ": " + (consumer.getPercentage() == 0 ? "-" : Integer.valueOf(consumer.getPercentage())));
            TreeItem treeConsumerItem05 = new TreeItem(treeConsumerItem0, 0);
            treeConsumerItem05.setText(String.valueOf(messages.getString("prorata")) + ": " + (consumer.getProrata() == 0 ? messages.getString("disabled") : messages.getString("enabled")));
        }
        final Menu menuTreeConsumers = new Menu((Control)this.treeConsumers);
        this.treeConsumers.setMenu(menuTreeConsumers);
        menuTreeConsumers.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                MenuItem[] items = menuTreeConsumers.getItems();
                int i = 0;
                while (i < items.length) {
                    items[i].dispose();
                    ++i;
                }
                MenuItem menuItemDelete = new MenuItem(menuTreeConsumers, 0);
                menuItemDelete.setText(messages.getString("delete"));
                menuItemDelete.addListener(13, new Listener(){

                    public void handleEvent(Event event) {
                        TreeItem treeItem = (this).EnergeticCommunitiesSimulator.this.treeConsumers.getSelection()[0];
                        if (treeItem.getParentItem() != null) {
                            treeItem = treeItem.getParentItem();
                        }
                        int result = 0;
                        CustomMessageBox mbConfirmDialog = new CustomMessageBox(shell, CustomMessageBox.ImageCode.WARNING, messages.getString("titleConfirmDeleteConsumer"), messages.getString("messageConfirmDeleteConsumer"));
                        mbConfirmDialog.addButton(messages.getString("no"), 0);
                        mbConfirmDialog.addButton(messages.getString("yes"), 1, true);
                        result = mbConfirmDialog.getResult();
                        if (result == 1) {
                            String podNumber = "";
                            itConsumers = consumers.iterator();
                            int i = 0;
                            while (itConsumers.hasNext()) {
                                Consumer consumer = (Consumer)itConsumers.next();
                                if (consumer.getName() == treeItem.getText()) {
                                    podNumber = consumer.getPodNumber();
                                    break;
                                }
                                ++i;
                            }
                            consumers.remove(i);
                            DatabaseConnection.removeConsumer(podNumber);
                            treeItem.dispose();
                            EnergeticCommunitiesSimulator.removeConsumerOrProducer(podNumber);
                            EnergeticCommunitiesSimulator.this.btnCompute.setEnabled(DatabaseConnection.computationCanBePerformed());
                            EnergeticCommunitiesSimulator.this.btnExportResults.setEnabled(DatabaseConnection.computationHasBeenPerformed());
                            EnergeticCommunitiesSimulator.updateDates();
                            EnergeticCommunitiesSimulator.updateTables();
                            EnergeticCommunitiesSimulator.updateChart();
                        }
                    }
                });
            }
        });
        Composite compProducers = new Composite((Composite)shell, 0);
        compProducers.setLayout((Layout)new GridLayout(2, false));
        GridData gd_compProducers = new GridData(4, 4, false, true, 1, 2);
        gd_compProducers.minimumWidth = 250;
        gd_compProducers.minimumHeight = 250;
        compProducers.setLayoutData((Object)gd_compProducers);
        Label lblProducers = new Label(compProducers, 0);
        lblProducers.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        lblProducers.setText(messages.getString("producers"));
        Button btnAddProducer = new Button(compProducers, 0);
        btnAddProducer.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        btnAddProducer.setText(messages.getString("add"));
        btnAddProducer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddProducer addProducer = new AddProducer(shell, producers, EnergeticCommunitiesSimulator.this.treeProducers, EnergeticCommunitiesSimulator.this.btnCompute, EnergeticCommunitiesSimulator.this.btnKeyConfiguration, EnergeticCommunitiesSimulator.this.btnExportResults, EnergeticCommunitiesSimulator.this.progressBar);
                addProducer.open();
            }
        });
        this.treeProducers = new Tree(compProducers, 2048);
        this.treeProducers.setLayoutData((Object)new GridData(4, 4, false, true, 2, 1));
        final Menu menuTreeProducers = new Menu((Control)this.treeProducers);
        this.treeProducers.setMenu(menuTreeProducers);
        menuTreeProducers.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                MenuItem[] items = menuTreeProducers.getItems();
                int i = 0;
                while (i < items.length) {
                    items[i].dispose();
                    ++i;
                }
                MenuItem menuItemDelete = new MenuItem(menuTreeProducers, 0);
                menuItemDelete.setText(messages.getString("delete"));
                menuItemDelete.addListener(13, new Listener(){

                    public void handleEvent(Event event) {
                        TreeItem treeItem = (this).EnergeticCommunitiesSimulator.this.treeProducers.getSelection()[0];
                        if (treeItem.getParentItem() != null) {
                            treeItem = treeItem.getParentItem();
                        }
                        int result = 0;
                        CustomMessageBox mbConfirmDialog = new CustomMessageBox(shell, CustomMessageBox.ImageCode.WARNING, messages.getString("titleConfirmDeleteProducer"), messages.getString("messageConfirmDeleteProducer"));
                        mbConfirmDialog.addButton(messages.getString("no"), 0);
                        mbConfirmDialog.addButton(messages.getString("yes"), 1, true);
                        result = mbConfirmDialog.getResult();
                        if (result == 1) {
                            String podNumber = "";
                            itProducers = producers.iterator();
                            int i = 0;
                            while (itProducers.hasNext()) {
                                Producer producer = (Producer)itProducers.next();
                                if (producer.getName() == treeItem.getText()) {
                                    podNumber = producer.getPodNumber();
                                    break;
                                }
                                ++i;
                            }
                            producers.remove(i);
                            DatabaseConnection.removeProducer(podNumber);
                            treeItem.dispose();
                            EnergeticCommunitiesSimulator.removeConsumerOrProducer(podNumber);
                            EnergeticCommunitiesSimulator.this.btnCompute.setEnabled(DatabaseConnection.computationCanBePerformed());
                            EnergeticCommunitiesSimulator.this.btnExportResults.setEnabled(DatabaseConnection.computationHasBeenPerformed());
                            EnergeticCommunitiesSimulator.updateDates();
                            EnergeticCommunitiesSimulator.updateTables();
                            EnergeticCommunitiesSimulator.updateChart();
                        }
                    }
                });
            }
        });
        for (Producer producer : producers) {
            TreeItem treeProducerItem0 = new TreeItem(this.treeProducers, 0);
            treeProducerItem0.setText(producer.getName());
            TreeItem treeProducerItem01 = new TreeItem(treeProducerItem0, 0);
            treeProducerItem01.setText(String.valueOf(messages.getString("startDate")) + ": " + dateFormat.format(producer.getStartDate()));
            TreeItem treeProducerItem02 = new TreeItem(treeProducerItem0, 0);
            treeProducerItem02.setText(String.valueOf(messages.getString("endDate")) + ": " + dateFormat.format(producer.getEndDate()));
            TreeItem treeProducerItem03 = new TreeItem(treeProducerItem0, 0);
            treeProducerItem03.setText(String.valueOf(messages.getString("priority")) + ": " + (producer.getPriority() == 0 ? "-" : Integer.valueOf(producer.getPriority())));
        }
        Label lblLegendGraph = new Label((Composite)shell, 0x1000000);
        lblLegendGraph.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        lblLegendGraph.setAlignment(0x1000000);
        lblLegendGraph.setText(messages.getString("legendGraph"));
        Composite compResults = new Composite((Composite)shell, 0);
        compResults.setLayoutData((Object)new GridData(4, 4, true, false, 1, 4));
        compResults.setLayout((Layout)new GridLayout(1, false));
        Label hSeparatorCol2 = new Label(compResults, 258);
        hSeparatorCol2.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        Label lblResultsConsumers = new Label(compResults, 0);
        lblResultsConsumers.setText(messages.getString("consumers"));
        Composite compResultsConsumers = new Composite(compResults, 0);
        compResultsConsumers.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        compResultsConsumers.setLayout((Layout)new FillLayout(256));
        tableConsumers = new Table(compResultsConsumers, 2816);
        GridData gdTableConsumers = new GridData(4, 128, true, true, 2, 1);
        gdTableConsumers.minimumHeight = 6 * tableConsumers.getItemHeight();
        tableConsumers.setLayoutData((Object)gdTableConsumers);
        tableConsumers.setHeaderVisible(true);
        tableConsumers.setLinesVisible(true);
        final TableColumn tableConsumersClmn00 = new TableColumn(tableConsumers, 0x1000000);
        tableConsumersClmn00.setResizable(false);
        final TableColumn tableConsumersClmn01 = new TableColumn(tableConsumers, 0);
        tableConsumersClmn01.setResizable(false);
        tableConsumersClmn01.setText(messages.getString("name"));
        final TableColumn tableConsumersClmn02 = new TableColumn(tableConsumers, 0x1000000);
        tableConsumersClmn02.setResizable(false);
        tableConsumersClmn02.setText(messages.getString("TotalEnergy"));
        final TableColumn tableConsumersClmn03 = new TableColumn(tableConsumers, 0x1000000);
        tableConsumersClmn03.setResizable(false);
        tableConsumersClmn03.setText(messages.getString("EnergyFromCommunity"));
        final TableColumn tableConsumersClmn04 = new TableColumn(tableConsumers, 0x1000000);
        tableConsumersClmn04.setResizable(false);
        tableConsumersClmn04.setText(messages.getString("EnergyFromNetwork"));
        final TableColumn tableConsumersClmn05 = new TableColumn(tableConsumers, 0x1000000);
        tableConsumersClmn05.setResizable(false);
        tableConsumers.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                Rectangle rect = tableConsumers.getClientArea();
                if (rect.width > 0) {
                    int space = rect.width / 18;
                    tableConsumersClmn00.setWidth(space / 2);
                    tableConsumersClmn01.setWidth(5 * space);
                    tableConsumersClmn02.setWidth(4 * space);
                    tableConsumersClmn03.setWidth(4 * space);
                    tableConsumersClmn04.setWidth(4 * space);
                    tableConsumersClmn05.setWidth(space / 2);
                }
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        tableConsumers.setToolTipText("");
        final Listener labelConsumerListener = new Listener(){

            public void handleEvent(Event e) {
                Label label = (Label)e.widget;
                Shell shell = label.getShell();
                switch (e.type) {
                    case 3: {
                        Event event = new Event();
                        event.item = (TableItem)label.getData("_TABLEITEM");
                        tableConsumers.setSelection(new TableItem[]{(TableItem)event.item});
                        tableConsumers.notifyListeners(13, event);
                        shell.dispose();
                        tableConsumers.setFocus();
                    }
                    case 7: {
                        shell.dispose();
                    }
                }
            }
        };
        Listener tableConsumersListener = new Listener(){
            Shell tip = null;
            Label label = null;

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 1: 
                    case 5: 
                    case 12: {
                        if (this.tip == null) break;
                        this.tip.dispose();
                        this.tip = null;
                        this.label = null;
                        break;
                    }
                    case 32: {
                        TableItem item;
                        Rectangle tableSize = tableConsumers.getClientArea();
                        int maxX = 0;
                        int minX = 0;
                        if (tableSize.width > 0) {
                            minX = tableSize.width / 36;
                            maxX = tableSize.width * 11 / 36;
                        }
                        if (event.x > maxX || event.x <= minX || (item = tableConsumers.getItem(new Point(1, event.y))) == null || item.getText(1) == messages.getString("TOTAL")) break;
                        if (this.tip != null && !this.tip.isDisposed()) {
                            this.tip.dispose();
                        }
                        this.tip = new Shell(shell, 540676);
                        this.tip.setLayout((Layout)new FillLayout());
                        this.label = new Label((Composite)this.tip, 0);
                        this.label.setForeground(display.getSystemColor(28));
                        this.label.setBackground(display.getSystemColor(29));
                        this.label.setData("_TABLEITEM", (Object)item);
                        this.label.setText(String.valueOf(messages.getString("PODNumber")) + " " + DatabaseConnection.getConsumerPodNumber(item.getText(1)));
                        this.label.addListener(7, labelConsumerListener);
                        this.label.addListener(3, labelConsumerListener);
                        Point size = this.tip.computeSize(-1, -1);
                        Rectangle rect = item.getBounds(1);
                        Point pt = tableConsumers.toDisplay(rect.x, rect.y);
                        this.tip.setBounds(pt.x, pt.y, size.x, size.y);
                        this.tip.setVisible(true);
                    }
                }
            }
        };
        tableConsumers.addListener(12, tableConsumersListener);
        tableConsumers.addListener(1, tableConsumersListener);
        tableConsumers.addListener(5, tableConsumersListener);
        tableConsumers.addListener(32, tableConsumersListener);
        Label lblResultsProducers = new Label(compResults, 0);
        lblResultsProducers.setText(messages.getString("producers"));
        Composite compResultsProducers = new Composite(compResults, 0);
        compResultsProducers.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        compResultsProducers.setLayout((Layout)new FillLayout(256));
        tableProducers = new Table(compResultsProducers, 2816);
        GridData gdTableProducers = new GridData(4, 128, false, true, 2, 1);
        gdTableProducers.minimumHeight = 6 * tableProducers.getItemHeight();
        tableProducers.setLayoutData((Object)gdTableProducers);
        tableProducers.setHeaderVisible(true);
        tableProducers.setLinesVisible(true);
        final TableColumn tableProducersClmn00 = new TableColumn(tableProducers, 0);
        tableProducersClmn00.setResizable(false);
        final TableColumn tableProducersClmn01 = new TableColumn(tableProducers, 0);
        tableProducersClmn01.setResizable(false);
        tableProducersClmn01.setText(messages.getString("name"));
        final TableColumn tableProducersClmn02 = new TableColumn(tableProducers, 0x1000000);
        tableProducersClmn02.setResizable(false);
        tableProducersClmn02.setText(messages.getString("TotalEnergy"));
        final TableColumn tableProducersClmn03 = new TableColumn(tableProducers, 0x1000000);
        tableProducersClmn03.setResizable(false);
        tableProducersClmn03.setText(messages.getString("EnergyToCommunity"));
        final TableColumn tableProducersClmn04 = new TableColumn(tableProducers, 0x1000000);
        tableProducersClmn04.setResizable(false);
        tableProducersClmn04.setText(messages.getString("EnergyToNetwork"));
        final TableColumn tableProducersClmn05 = new TableColumn(tableProducers, 0x1000000);
        tableProducersClmn05.setResizable(false);
        tableProducers.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                Rectangle rect = tableProducers.getClientArea();
                if (rect.width > 0) {
                    int space = rect.width / 18;
                    tableProducersClmn00.setWidth(space / 2);
                    tableProducersClmn01.setWidth(5 * space);
                    tableProducersClmn02.setWidth(4 * space);
                    tableProducersClmn03.setWidth(4 * space);
                    tableProducersClmn04.setWidth(4 * space);
                    tableProducersClmn05.setWidth(space / 2);
                }
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        tableProducers.setToolTipText("");
        final Listener labelProducerListener = new Listener(){

            public void handleEvent(Event e) {
                Label label = (Label)e.widget;
                Shell shell = label.getShell();
                switch (e.type) {
                    case 3: {
                        Event event = new Event();
                        event.item = (TableItem)label.getData("_TABLEITEM");
                        tableProducers.setSelection(new TableItem[]{(TableItem)event.item});
                        tableProducers.notifyListeners(13, event);
                        shell.dispose();
                        tableProducers.setFocus();
                    }
                    case 7: {
                        shell.dispose();
                    }
                }
            }
        };
        Listener tableProducersListener = new Listener(){
            Shell tip = null;
            Label label = null;

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 1: 
                    case 5: 
                    case 12: {
                        if (this.tip == null) break;
                        this.tip.dispose();
                        this.tip = null;
                        this.label = null;
                        break;
                    }
                    case 32: {
                        TableItem item;
                        Rectangle tableSize = tableProducers.getClientArea();
                        int maxX = 0;
                        int minX = 0;
                        if (tableSize.width > 0) {
                            minX = tableSize.width / 36;
                            maxX = tableSize.width * 11 / 36;
                        }
                        if (event.x > maxX || event.x <= minX || (item = tableProducers.getItem(new Point(1, event.y))) == null || item.getText(1) == messages.getString("TOTAL")) break;
                        if (this.tip != null && !this.tip.isDisposed()) {
                            this.tip.dispose();
                        }
                        this.tip = new Shell(shell, 540676);
                        this.tip.setLayout((Layout)new FillLayout());
                        this.label = new Label((Composite)this.tip, 0);
                        this.label.setForeground(display.getSystemColor(28));
                        this.label.setBackground(display.getSystemColor(29));
                        this.label.setData("_TABLEITEM", (Object)item);
                        this.label.setText(String.valueOf(messages.getString("PODNumber")) + " " + DatabaseConnection.getProducerPodNumber(item.getText(1)));
                        this.label.addListener(7, labelProducerListener);
                        this.label.addListener(3, labelProducerListener);
                        Point size = this.tip.computeSize(-1, -1);
                        Rectangle rect = item.getBounds(1);
                        Point pt = tableProducers.toDisplay(rect.x, rect.y);
                        this.tip.setBounds(pt.x, pt.y, size.x, size.y);
                        this.tip.setVisible(true);
                    }
                }
            }
        };
        tableProducers.addListener(12, tableProducersListener);
        tableProducers.addListener(1, tableProducersListener);
        tableProducers.addListener(5, tableProducersListener);
        tableProducers.addListener(32, tableProducersListener);
        Label hSeparatorCol1 = new Label((Composite)shell, 258);
        hSeparatorCol1.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        Composite compKeyConfig = new Composite((Composite)shell, 0);
        compKeyConfig.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        compKeyConfig.setLayout((Layout)new FillLayout(256));
        this.btnKeyConfiguration = new Button(compKeyConfig, 0);
        this.btnKeyConfiguration.setText(messages.getString("keyConfiguration"));
        this.btnKeyConfiguration.setEnabled(DatabaseConnection.consumerAndProducerDefined());
        this.btnKeyConfiguration.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                KeyConfiguration keyConfiguration = new KeyConfiguration(shell, consumers, EnergeticCommunitiesSimulator.this.treeConsumers, producers, EnergeticCommunitiesSimulator.this.treeProducers, EnergeticCommunitiesSimulator.this.btnCompute, EnergeticCommunitiesSimulator.this.btnExportResults);
                keyConfiguration.open();
            }
        });
        Composite compTimeRange = new Composite((Composite)shell, 0);
        compTimeRange.setLayout((Layout)new GridLayout(3, false));
        GridData gd_compTimeRange = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_compTimeRange.minimumHeight = 80;
        compTimeRange.setLayoutData((Object)gd_compTimeRange);
        Label lblTimeRange = new Label(compTimeRange, 0);
        lblTimeRange.setBounds(0, 0, 70, 20);
        lblTimeRange.setText(messages.getString("timeRange"));
        new Label(compTimeRange, 0);
        new Label(compTimeRange, 0);
        Button btnRadioButtonWeek = new Button(compTimeRange, 16);
        btnRadioButtonWeek.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        btnRadioButtonWeek.setText(messages.getString("last7days"));
        btnRadioButtonWeek.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button source = (Button)e.getSource();
                if (source.getSelection()) {
                    lblStartDate.setEnabled(false);
                    lblEndDate.setEnabled(false);
                    currentEndDate = DatabaseConnection.getLatestEndDate().toLocalDate();
                    currentStartDate = currentEndDate.minusDays(7L);
                    lblStartDate.setText(currentStartDate.format(dateFormatter));
                    lblEndDate.setText(currentEndDate.format(dateFormatter));
                    EnergeticCommunitiesSimulator.updateTables();
                    EnergeticCommunitiesSimulator.updateChart();
                }
            }
        });
        Button btnRadioButtonYear = new Button(compTimeRange, 16);
        btnRadioButtonYear.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        btnRadioButtonYear.setText(messages.getString("last365days"));
        btnRadioButtonYear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button source = (Button)e.getSource();
                if (source.getSelection()) {
                    lblStartDate.setEnabled(false);
                    lblEndDate.setEnabled(false);
                    currentEndDate = DatabaseConnection.getLatestEndDate().toLocalDate();
                    currentStartDate = currentEndDate.minusDays(365L);
                    LocalDate latestDate = DatabaseConnection.getOldestStartDate().toLocalDate();
                    if (currentStartDate.isBefore(latestDate)) {
                        currentStartDate = latestDate;
                    }
                    lblStartDate.setText(currentStartDate.format(dateFormatter));
                    lblEndDate.setText(currentEndDate.format(dateFormatter));
                    EnergeticCommunitiesSimulator.updateTables();
                    EnergeticCommunitiesSimulator.updateChart();
                }
            }
        });
        Button btnRadioButtonCustom = new Button(compTimeRange, 16);
        btnRadioButtonCustom.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        btnRadioButtonCustom.setText(messages.getString("custom"));
        btnRadioButtonCustom.setSelection(true);
        btnRadioButtonCustom.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button source = (Button)e.getSource();
                if (source.getSelection()) {
                    lblStartDate.setEnabled(true);
                    lblEndDate.setEnabled(true);
                }
            }
        });
        Label lblFrom = new Label(compTimeRange, 0);
        lblFrom.setLayoutData((Object)new GridData(131072, 0x1000000, true, true, 1, 1));
        lblFrom.setText(messages.getString("from"));
        lblStartDate = new Label(compTimeRange, 0);
        lblStartDate.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        lblStartDate.setBackground(SWTResourceManager.getColor(38));
        LocalDate localStartDate1 = DatabaseConnection.getOldestStartDate().toLocalDate();
        lblStartDate.setText(localStartDate1.format(dateFormatter));
        currentStartDate = localStartDate1;
        lblStartDate.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                final Shell dialog = new Shell(shell, 65536);
                dialog.setLayout((Layout)new GridLayout(2, true));
                final DateTime calendar = new DateTime((Composite)dialog, 3072);
                calendar.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
                calendar.setDate(currentStartDate.getYear(), currentStartDate.getMonthValue() - 1, currentStartDate.getDayOfMonth());
                calendar.addListener(13, new Listener(){

                    public void handleEvent(Event arg0) {
                        int day = calendar.getDay();
                        int month = calendar.getMonth() + 1;
                        int year = calendar.getYear();
                        LocalDate newDate = null;
                        try {
                            newDate = LocalDate.of(year, month, day);
                        }
                        catch (Exception e) {
                            return;
                        }
                        if (newDate.isBefore(DatabaseConnection.getOldestStartDate().toLocalDate())) {
                            LocalDate localStartDate = DatabaseConnection.getOldestStartDate().toLocalDate();
                            calendar.setDate(localStartDate.getYear(), localStartDate.getMonthValue() - 1, localStartDate.getDayOfMonth());
                        } else if (newDate.isAfter(DatabaseConnection.getLatestEndDate().toLocalDate())) {
                            LocalDate localStartDate = DatabaseConnection.getLatestEndDate().toLocalDate();
                            calendar.setDate(localStartDate.getYear(), localStartDate.getMonthValue() - 1, localStartDate.getDayOfMonth());
                        } else if (newDate.isAfter(currentEndDate)) {
                            calendar.setDate(currentEndDate.getYear(), currentEndDate.getMonthValue() - 1, currentEndDate.getDayOfMonth());
                        }
                    }
                });
                Button bDefault = new Button((Composite)dialog, 8);
                bDefault.setText(messages.getString("default"));
                bDefault.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
                bDefault.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        LocalDate oldestDate = DatabaseConnection.getOldestStartDate().toLocalDate();
                        calendar.setDate(oldestDate.getYear(), oldestDate.getMonthValue() - 1, oldestDate.getDayOfMonth());
                    }
                });
                Button bCancel = new Button((Composite)dialog, 8);
                bCancel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
                bCancel.setText(messages.getString("cancel"));
                bCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        dialog.close();
                    }
                });
                Button bOk = new Button((Composite)dialog, 8);
                bOk.setText(messages.getString("ok"));
                bOk.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
                bOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        int day = calendar.getDay();
                        int month = calendar.getMonth() + 1;
                        int year = calendar.getYear();
                        LocalDate newDate = null;
                        try {
                            newDate = LocalDate.of(year, month, day);
                        }
                        catch (Exception ex) {
                            return;
                        }
                        if (newDate.isBefore(DatabaseConnection.getOldestStartDate().toLocalDate())) {
                            LocalDate localStartDate = DatabaseConnection.getOldestStartDate().toLocalDate();
                            calendar.setDate(localStartDate.getYear(), localStartDate.getMonthValue() - 1, localStartDate.getDayOfMonth());
                        } else if (newDate.isAfter(DatabaseConnection.getLatestEndDate().toLocalDate())) {
                            LocalDate localStartDate = DatabaseConnection.getLatestEndDate().toLocalDate();
                            calendar.setDate(localStartDate.getYear(), localStartDate.getMonthValue() - 1, localStartDate.getDayOfMonth());
                        } else if (newDate.isAfter(currentEndDate)) {
                            calendar.setDate(currentEndDate.getYear(), currentEndDate.getMonthValue() - 1, currentEndDate.getDayOfMonth());
                        } else {
                            lblStartDate.setText(String.format("%02d/%02d/%04d", calendar.getDay(), calendar.getMonth() + 1, calendar.getYear()));
                            currentStartDate = LocalDate.of(calendar.getYear(), calendar.getMonth() + 1, calendar.getDay());
                            dialog.close();
                            EnergeticCommunitiesSimulator.updateTables();
                            EnergeticCommunitiesSimulator.updateChart();
                        }
                    }
                });
                Point pt = Display.getCurrent().getCursorLocation();
                Point ptDialog = new Point(pt.x, pt.y - 200);
                dialog.getShell().setLocation(ptDialog);
                dialog.setDefaultButton(bOk);
                dialog.pack();
                dialog.open();
            }
        });
        Label lblTo = new Label(compTimeRange, 0);
        lblTo.setLayoutData((Object)new GridData(131072, 0x1000000, true, true, 1, 1));
        lblTo.setText(messages.getString("to"));
        lblEndDate = new Label(compTimeRange, 0);
        lblEndDate.setBackground(SWTResourceManager.getColor(38));
        LocalDate localEndDate1 = DatabaseConnection.getLatestEndDate().toLocalDate();
        lblEndDate.setText(localEndDate1.format(dateFormatter));
        currentEndDate = localEndDate1;
        lblEndDate.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                final Shell dialog = new Shell(shell, 65536);
                dialog.setLayout((Layout)new GridLayout(2, false));
                final DateTime calendar = new DateTime((Composite)dialog, 3072);
                calendar.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
                calendar.setDate(currentEndDate.getYear(), currentEndDate.getMonthValue() - 1, currentEndDate.getDayOfMonth());
                calendar.addListener(13, new Listener(){

                    public void handleEvent(Event arg0) {
                        int day = calendar.getDay();
                        int month = calendar.getMonth() + 1;
                        int year = calendar.getYear();
                        LocalDate newDate = null;
                        try {
                            newDate = LocalDate.of(year, month, day);
                        }
                        catch (Exception e) {
                            return;
                        }
                        if (newDate.isBefore(DatabaseConnection.getOldestStartDate().toLocalDate())) {
                            LocalDate localEndDate = DatabaseConnection.getOldestStartDate().toLocalDate();
                            calendar.setDate(localEndDate.getYear(), localEndDate.getMonthValue() - 1, localEndDate.getDayOfMonth());
                        } else if (newDate.isAfter(DatabaseConnection.getLatestEndDate().toLocalDate())) {
                            LocalDate localEndDate = DatabaseConnection.getLatestEndDate().toLocalDate();
                            calendar.setDate(localEndDate.getYear(), localEndDate.getMonthValue() - 1, localEndDate.getDayOfMonth());
                        } else if (newDate.isBefore(currentStartDate)) {
                            calendar.setDate(currentStartDate.getYear(), currentStartDate.getMonthValue() - 1, currentStartDate.getDayOfMonth());
                        }
                    }
                });
                Button bDefault = new Button((Composite)dialog, 8);
                bDefault.setText(messages.getString("default"));
                bDefault.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
                bDefault.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        LocalDate latestDate = DatabaseConnection.getLatestEndDate().toLocalDate();
                        calendar.setDate(latestDate.getYear(), latestDate.getMonthValue() - 1, latestDate.getDayOfMonth());
                    }
                });
                Button bCancel = new Button((Composite)dialog, 8);
                bCancel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
                bCancel.setText(messages.getString("cancel"));
                bCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        dialog.close();
                    }
                });
                Button bOk = new Button((Composite)dialog, 8);
                bOk.setText(messages.getString("ok"));
                bOk.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
                bOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        int day = calendar.getDay();
                        int month = calendar.getMonth() + 1;
                        int year = calendar.getYear();
                        LocalDate newDate = null;
                        try {
                            newDate = LocalDate.of(year, month, day);
                        }
                        catch (Exception ex) {
                            return;
                        }
                        if (newDate.isBefore(DatabaseConnection.getOldestStartDate().toLocalDate())) {
                            LocalDate localEndDate = DatabaseConnection.getOldestStartDate().toLocalDate();
                            calendar.setDate(localEndDate.getYear(), localEndDate.getMonthValue() - 1, localEndDate.getDayOfMonth());
                        } else if (newDate.isAfter(DatabaseConnection.getLatestEndDate().toLocalDate())) {
                            LocalDate localEndDate = DatabaseConnection.getLatestEndDate().toLocalDate();
                            calendar.setDate(localEndDate.getYear(), localEndDate.getMonthValue() - 1, localEndDate.getDayOfMonth());
                        } else if (newDate.isBefore(currentStartDate)) {
                            calendar.setDate(currentStartDate.getYear(), currentStartDate.getMonthValue() - 1, currentStartDate.getDayOfMonth());
                        } else {
                            currentEndDate = LocalDate.of(calendar.getYear(), calendar.getMonth() + 1, calendar.getDay());
                            lblEndDate.setText(String.format("%02d/%02d/%04d", calendar.getDay(), calendar.getMonth() + 1, calendar.getYear()));
                            dialog.close();
                            EnergeticCommunitiesSimulator.updateTables();
                            EnergeticCommunitiesSimulator.updateChart();
                        }
                    }
                });
                Point pt = Display.getCurrent().getCursorLocation();
                Point ptDialog = new Point(pt.x, pt.y - 200);
                dialog.getShell().setLocation(ptDialog);
                dialog.setDefaultButton(bOk);
                dialog.pack();
                dialog.open();
            }
        });
        EnergeticCommunitiesSimulator.updateChart();
        new Label(compTimeRange, 0);
        Double consumersTotalEnergy = 0.0;
        Double consumersEnergyCommunity = 0.0;
        Double consumersEnergyNetwork = 0.0;
        for (final Consumer consumer : consumers) {
            tableItem = new TableItem(tableConsumers, 0);
            TableEditor tableEditorCheckButtonConsumer = new TableEditor(tableConsumers);
            Button checkButtonConsumer = new Button((Composite)tableConsumers, 32);
            checkButtonConsumer.setSelection(false);
            checkButtonConsumer.pack();
            tableEditorCheckButtonConsumer.minimumWidth = checkButtonConsumer.getSize().x;
            tableEditorCheckButtonConsumer.horizontalAlignment = 0x1000000;
            tableEditorCheckButtonConsumer.setEditor((Control)checkButtonConsumer, tableItem, 0);
            tableItem.setData("allSelected", (Object)checkButtonConsumer);
            checkButtonConsumer.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    int i = 0;
                    while (i < tableConsumers.getItemCount()) {
                        EnergeticCommunitiesSimulator.tableItem = tableConsumers.getItem(i);
                        if (tableItem.getData("allSelected") == (Button)e.getSource()) {
                            boolean selection = ((Button)e.getSource()).getSelection();
                            showAllLines.put(consumer.getPodNumber(), selection);
                            Button button = (Button)tableItem.getData("totalSelected");
                            button.setSelection(selection);
                            button.notifyListeners(13, new Event());
                            button = (Button)tableItem.getData("communitySelected");
                            if (button.getEnabled()) {
                                button.setSelection(selection);
                                button.notifyListeners(13, new Event());
                            }
                            if (!(button = (Button)tableItem.getData("networkSelected")).getEnabled()) break;
                            button.setSelection(selection);
                            button.notifyListeners(13, new Event());
                            break;
                        }
                        ++i;
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            TableEditor tableEditorCheckButtonConsumerTotal = new TableEditor(tableConsumers);
            Button checkButtonConsumerTotal = new Button((Composite)tableConsumers, 32);
            checkButtonConsumerTotal.setSelection(false);
            checkButtonConsumerTotal.pack();
            tableEditorCheckButtonConsumerTotal.minimumWidth = checkButtonConsumerTotal.getSize().x;
            tableEditorCheckButtonConsumerTotal.horizontalAlignment = 16384;
            tableEditorCheckButtonConsumerTotal.setEditor((Control)checkButtonConsumerTotal, tableItem, 2);
            tableItem.setData("totalSelected", (Object)checkButtonConsumerTotal);
            checkButtonConsumerTotal.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    int i = 0;
                    while (i < tableConsumers.getItemCount()) {
                        EnergeticCommunitiesSimulator.tableItem = tableConsumers.getItem(i);
                        if (tableItem.getData("totalSelected") == (Button)e.getSource()) {
                            boolean selection = ((Button)e.getSource()).getSelection();
                            if (!selection) {
                                showAllLines.put(consumer.getPodNumber(), selection);
                                Button button = (Button)tableItem.getData("allSelected");
                                button.setSelection(selection);
                            } else {
                                Button button = (Button)tableItem.getData("communitySelected");
                                if (button.getSelection() && (button = (Button)tableItem.getData("networkSelected")).getSelection()) {
                                    showAllLines.put(consumer.getPodNumber(), selection);
                                    button = (Button)tableItem.getData("allSelected");
                                    button.setSelection(selection);
                                }
                            }
                            showLinesTotalEnergy.put(consumer.getPodNumber(), selection);
                            EnergeticCommunitiesSimulator.updateChart();
                            break;
                        }
                        ++i;
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            TableEditor tableEditorCheckButtonConsumerCommunity = new TableEditor(tableConsumers);
            Button checkButtonConsumerCommunity = new Button((Composite)tableConsumers, 32);
            checkButtonConsumerCommunity.setSelection(false);
            checkButtonConsumerCommunity.pack();
            tableEditorCheckButtonConsumerCommunity.minimumWidth = checkButtonConsumerCommunity.getSize().x;
            tableEditorCheckButtonConsumerCommunity.horizontalAlignment = 16384;
            tableEditorCheckButtonConsumerCommunity.setEditor((Control)checkButtonConsumerCommunity, tableItem, 3);
            tableItem.setData("communitySelected", (Object)checkButtonConsumerCommunity);
            checkButtonConsumerCommunity.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    int i = 0;
                    while (i < tableConsumers.getItemCount()) {
                        EnergeticCommunitiesSimulator.tableItem = tableConsumers.getItem(i);
                        if (tableItem.getData("communitySelected") == (Button)e.getSource()) {
                            boolean selection = ((Button)e.getSource()).getSelection();
                            if (!selection) {
                                showAllLines.put(consumer.getPodNumber(), selection);
                                Button button = (Button)tableItem.getData("allSelected");
                                button.setSelection(selection);
                            } else {
                                Button button = (Button)tableItem.getData("totalSelected");
                                if (button.getSelection() && (button = (Button)tableItem.getData("networkSelected")).getSelection()) {
                                    showAllLines.put(consumer.getPodNumber(), selection);
                                    button = (Button)tableItem.getData("allSelected");
                                    button.setSelection(selection);
                                }
                            }
                            showLinesCommunityEnergy.put(consumer.getPodNumber(), selection);
                            EnergeticCommunitiesSimulator.updateChart();
                            break;
                        }
                        ++i;
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            TableEditor tableEditorCheckButtonConsumerNetwork = new TableEditor(tableConsumers);
            Button checkButtonConsumerNetwork = new Button((Composite)tableConsumers, 32);
            checkButtonConsumerNetwork.setSelection(false);
            checkButtonConsumerNetwork.pack();
            tableEditorCheckButtonConsumerNetwork.minimumWidth = checkButtonConsumerNetwork.getSize().x;
            tableEditorCheckButtonConsumerNetwork.horizontalAlignment = 16384;
            tableEditorCheckButtonConsumerNetwork.setEditor((Control)checkButtonConsumerNetwork, tableItem, 4);
            tableItem.setData("networkSelected", (Object)checkButtonConsumerNetwork);
            checkButtonConsumerNetwork.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    int i = 0;
                    while (i < tableConsumers.getItemCount()) {
                        EnergeticCommunitiesSimulator.tableItem = tableConsumers.getItem(i);
                        if (tableItem.getData("networkSelected") == (Button)e.getSource()) {
                            boolean selection = ((Button)e.getSource()).getSelection();
                            if (!selection) {
                                showAllLines.put(consumer.getPodNumber(), selection);
                                Button button = (Button)tableItem.getData("allSelected");
                                button.setSelection(selection);
                            } else {
                                Button button = (Button)tableItem.getData("totalSelected");
                                if (button.getSelection() && (button = (Button)tableItem.getData("communitySelected")).getSelection()) {
                                    showAllLines.put(consumer.getPodNumber(), selection);
                                    button = (Button)tableItem.getData("allSelected");
                                    button.setSelection(selection);
                                }
                            }
                            showLinesNetworkEnergy.put(consumer.getPodNumber(), selection);
                            EnergeticCommunitiesSimulator.updateChart();
                            break;
                        }
                        ++i;
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            tableItem.setText(1, consumer.getName());
            tableItem.setText(2, format.format(DatabaseConnection.getTotalEnergy(consumer.getPodNumber(), currentStartDate, currentEndDate)));
            consumersTotalEnergy = consumersTotalEnergy + DatabaseConnection.getTotalEnergy(consumer.getPodNumber(), currentStartDate, currentEndDate);
            Double energyCommunity = DatabaseConnection.getCommunityEnergy(consumer.getPodNumber(), currentStartDate, currentEndDate);
            if (DatabaseConnection.computationHasBeenPerformed()) {
                tableItem.setText(3, format.format(energyCommunity));
                consumersEnergyCommunity = consumersEnergyCommunity + energyCommunity;
            } else {
                checkButtonConsumerCommunity.setEnabled(false);
                checkButtonConsumerCommunity.setSelection(false);
                showLinesCommunityEnergy.put(consumer.getPodNumber(), false);
            }
            Double energyNetwork = DatabaseConnection.getNetworkEnergy(consumer.getPodNumber(), currentStartDate, currentEndDate);
            if (DatabaseConnection.computationHasBeenPerformed()) {
                tableItem.setText(4, format.format(energyNetwork));
                consumersEnergyNetwork = consumersEnergyNetwork + energyNetwork;
            } else {
                checkButtonConsumerNetwork.setEnabled(false);
                checkButtonConsumerCommunity.setSelection(false);
                showLinesNetworkEnergy.put(consumer.getPodNumber(), false);
            }
            tableItem.setBackground(5, consumer.getColor());
        }
        tableItem = new TableItem(tableConsumers, 0);
        tableItem.setText(1, messages.getString("TOTAL"));
        tableItem.setText(2, format.format(consumersTotalEnergy));
        if (DatabaseConnection.computationHasBeenPerformed()) {
            tableItem.setText(3, format.format(consumersEnergyCommunity));
            tableItem.setText(4, format.format(consumersEnergyNetwork));
        }
        tableConsumers.pack();
        Double producersTotalEnergy = 0.0;
        Double producersEnergyCommunity = 0.0;
        Double producersEnergyNetwork = 0.0;
        for (final Producer producer : producers) {
            tableItem = new TableItem(tableProducers, 0);
            TableEditor tableEditorCheckButtonProducer = new TableEditor(tableProducers);
            Button checkButtonProducer = new Button((Composite)tableProducers, 32);
            checkButtonProducer.setSelection(false);
            checkButtonProducer.pack();
            tableEditorCheckButtonProducer.minimumWidth = checkButtonProducer.getSize().x;
            tableEditorCheckButtonProducer.horizontalAlignment = 0x1000000;
            tableEditorCheckButtonProducer.setEditor((Control)checkButtonProducer, tableItem, 0);
            tableItem.setData("allSelected", (Object)checkButtonProducer);
            checkButtonProducer.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    boolean found = false;
                    int i = 0;
                    while (!found && i < tableProducers.getItemCount()) {
                        EnergeticCommunitiesSimulator.tableItem = tableProducers.getItem(i);
                        if (tableItem.getData("allSelected") == (Button)e.getSource()) {
                            boolean selection = ((Button)e.getSource()).getSelection();
                            showAllLines.put(producer.getPodNumber(), selection);
                            Button button = (Button)tableItem.getData("totalSelected");
                            button.setSelection(selection);
                            button.notifyListeners(13, new Event());
                            button = (Button)tableItem.getData("communitySelected");
                            if (button.getEnabled()) {
                                button.setSelection(selection);
                                button.notifyListeners(13, new Event());
                            }
                            if (!(button = (Button)tableItem.getData("networkSelected")).getEnabled()) break;
                            button.setSelection(selection);
                            button.notifyListeners(13, new Event());
                            break;
                        }
                        ++i;
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            TableEditor tableEditorCheckButtonProducerTotal = new TableEditor(tableProducers);
            Button checkButtonProducerTotal = new Button((Composite)tableProducers, 32);
            checkButtonProducerTotal.setSelection(false);
            checkButtonProducerTotal.pack();
            tableEditorCheckButtonProducerTotal.minimumWidth = checkButtonProducerTotal.getSize().x;
            tableEditorCheckButtonProducerTotal.horizontalAlignment = 16384;
            tableEditorCheckButtonProducerTotal.setEditor((Control)checkButtonProducerTotal, tableItem, 2);
            tableItem.setData("totalSelected", (Object)checkButtonProducerTotal);
            checkButtonProducerTotal.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    int i = 0;
                    while (i < tableProducers.getItemCount()) {
                        EnergeticCommunitiesSimulator.tableItem = tableProducers.getItem(i);
                        if (tableItem.getData("totalSelected") == (Button)e.getSource()) {
                            boolean selection = ((Button)e.getSource()).getSelection();
                            if (!selection) {
                                showAllLines.put(producer.getPodNumber(), selection);
                                Button button = (Button)tableItem.getData("allSelected");
                                button.setSelection(selection);
                            } else {
                                Button button = (Button)tableItem.getData("communitySelected");
                                if (button.getSelection() && (button = (Button)tableItem.getData("networkSelected")).getSelection()) {
                                    showAllLines.put(producer.getPodNumber(), selection);
                                    button = (Button)tableItem.getData("allSelected");
                                    button.setSelection(selection);
                                }
                            }
                            showLinesTotalEnergy.put(producer.getPodNumber(), selection);
                            EnergeticCommunitiesSimulator.updateChart();
                            break;
                        }
                        ++i;
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            TableEditor tableEditorCheckButtonProducerCommunity = new TableEditor(tableProducers);
            Button checkButtonProducerCommunity = new Button((Composite)tableProducers, 32);
            checkButtonProducerCommunity.setSelection(false);
            checkButtonProducerCommunity.pack();
            tableEditorCheckButtonProducerCommunity.minimumWidth = checkButtonProducerCommunity.getSize().x;
            tableEditorCheckButtonProducerCommunity.horizontalAlignment = 16384;
            tableEditorCheckButtonProducerCommunity.setEditor((Control)checkButtonProducerCommunity, tableItem, 3);
            tableItem.setData("communitySelected", (Object)checkButtonProducerCommunity);
            checkButtonProducerCommunity.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    int i = 0;
                    while (i < tableProducers.getItemCount()) {
                        EnergeticCommunitiesSimulator.tableItem = tableProducers.getItem(i);
                        if (tableItem.getData("communitySelected") == (Button)e.getSource()) {
                            boolean selection = ((Button)e.getSource()).getSelection();
                            if (!selection) {
                                showAllLines.put(producer.getPodNumber(), selection);
                                Button button = (Button)tableItem.getData("allSelected");
                                button.setSelection(selection);
                            } else {
                                Button button = (Button)tableItem.getData("totalSelected");
                                if (button.getSelection() && (button = (Button)tableItem.getData("networkSelected")).getSelection()) {
                                    showAllLines.put(producer.getPodNumber(), selection);
                                    button = (Button)tableItem.getData("allSelected");
                                    button.setSelection(selection);
                                }
                            }
                            showLinesCommunityEnergy.put(producer.getPodNumber(), selection);
                            EnergeticCommunitiesSimulator.updateChart();
                            break;
                        }
                        ++i;
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            TableEditor tableEditorCheckButtonProducerNetwork = new TableEditor(tableProducers);
            Button checkButtonProducerNetwork = new Button((Composite)tableProducers, 32);
            checkButtonProducerNetwork.setSelection(false);
            checkButtonProducerNetwork.pack();
            tableEditorCheckButtonProducerNetwork.minimumWidth = checkButtonProducerNetwork.getSize().x;
            tableEditorCheckButtonProducerNetwork.horizontalAlignment = 16384;
            tableEditorCheckButtonProducerNetwork.setEditor((Control)checkButtonProducerNetwork, tableItem, 4);
            tableItem.setData("networkSelected", (Object)checkButtonProducerNetwork);
            checkButtonProducerNetwork.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    int i = 0;
                    while (i < tableProducers.getItemCount()) {
                        EnergeticCommunitiesSimulator.tableItem = tableProducers.getItem(i);
                        if (tableItem.getData("networkSelected") == (Button)e.getSource()) {
                            boolean selection = ((Button)e.getSource()).getSelection();
                            if (!selection) {
                                showAllLines.put(producer.getPodNumber(), selection);
                                Button button = (Button)tableItem.getData("allSelected");
                                button.setSelection(selection);
                            } else {
                                Button button = (Button)tableItem.getData("totalSelected");
                                if (button.getSelection() && (button = (Button)tableItem.getData("communitySelected")).getSelection()) {
                                    showAllLines.put(producer.getPodNumber(), selection);
                                    button = (Button)tableItem.getData("allSelected");
                                    button.setSelection(selection);
                                }
                            }
                            showLinesNetworkEnergy.put(producer.getPodNumber(), selection);
                            EnergeticCommunitiesSimulator.updateChart();
                            break;
                        }
                        ++i;
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            tableItem.setText(1, producer.getName());
            tableItem.setText(2, format.format(DatabaseConnection.getTotalEnergy(producer.getPodNumber(), currentStartDate, currentEndDate)));
            producersTotalEnergy = producersTotalEnergy + DatabaseConnection.getTotalEnergy(producer.getPodNumber(), currentStartDate, currentEndDate);
            Double energyCommunity = DatabaseConnection.getCommunityEnergy(producer.getPodNumber(), currentStartDate, currentEndDate);
            if (DatabaseConnection.computationHasBeenPerformed()) {
                tableItem.setText(3, format.format(energyCommunity));
                producersEnergyCommunity = producersEnergyCommunity + energyCommunity;
            } else {
                checkButtonProducerCommunity.setEnabled(false);
                checkButtonProducerCommunity.setSelection(false);
                showLinesCommunityEnergy.put(producer.getPodNumber(), false);
            }
            Double energyNetwork = DatabaseConnection.getNetworkEnergy(producer.getPodNumber(), currentStartDate, currentEndDate);
            if (DatabaseConnection.computationHasBeenPerformed()) {
                tableItem.setText(4, format.format(energyNetwork));
                producersEnergyNetwork = producersEnergyNetwork + energyNetwork;
            } else {
                checkButtonProducerNetwork.setEnabled(false);
                checkButtonProducerNetwork.setSelection(false);
                showLinesNetworkEnergy.put(producer.getPodNumber(), false);
            }
            tableItem.setBackground(5, producer.getColor());
        }
        tableItem = new TableItem(tableProducers, 0);
        tableItem.setText(1, messages.getString("TOTAL"));
        tableItem.setText(2, format.format(producersTotalEnergy));
        if (DatabaseConnection.computationHasBeenPerformed()) {
            tableItem.setText(3, format.format(producersEnergyCommunity));
            tableItem.setText(4, format.format(producersEnergyNetwork));
        }
        tableProducers.pack();
        Composite compCompute = new Composite((Composite)shell, 0);
        compCompute.setLayout((Layout)new FillLayout(256));
        compCompute.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnCompute = new Button(compCompute, 0);
        this.btnCompute.setText(messages.getString("compute"));
        this.btnCompute.setEnabled(DatabaseConnection.computationCanBePerformed());
        this.btnCompute.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ComputeSharing.compute(currentStartDate, currentEndDate, EnergeticCommunitiesSimulator.this.progressBar);
                EnergeticCommunitiesSimulator.this.btnCompute.setEnabled(false);
                EnergeticCommunitiesSimulator.this.btnExportResults.setEnabled(DatabaseConnection.computationHasBeenPerformed());
            }
        });
        Composite compExport = new Composite((Composite)shell, 0);
        compExport.setLayout((Layout)new FillLayout(256));
        compExport.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 1, 1));
        Button btnExportChart = new Button(compExport, 0);
        btnExportChart.setBounds(0, 0, 90, 30);
        btnExportChart.setText(messages.getString("exportChart"));
        btnExportChart.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                String[] extensions = new String[]{"*.jpeg", "*.jpg", "*.png"};
                FileDialog dialog = new FileDialog(shell, 8192);
                dialog.setFilterExtensions(extensions);
                String filename = dialog.open();
                if (filename == null) {
                    return;
                }
                int format = filename.endsWith(".jpg") || filename.endsWith(".jpeg") ? 4 : (filename.endsWith(".png") ? 5 : -1);
                if (format != -1) {
                    chart.save(filename, format);
                    MessageBox successMessageBox = new MessageBox(shell, 34);
                    successMessageBox.setMessage(String.valueOf(messages.getString("successExportChart")) + " " + filename);
                    successMessageBox.open();
                }
            }
        });
        this.btnExportResults = new Button(compExport, 0);
        this.btnExportResults.setBounds(0, 0, 90, 30);
        this.btnExportResults.setText(messages.getString("exportResults"));
        this.btnExportResults.setEnabled(DatabaseConnection.computationHasBeenPerformed());
        this.btnExportResults.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                String[] extensions = new String[]{"*.csv"};
                FileDialog dialog = new FileDialog(shell, 8192);
                dialog.setFilterExtensions(extensions);
                String filename = dialog.open();
                if (filename == null) {
                    return;
                }
                Export.exportAsCSV(shell, currentStartDate, currentEndDate, filename);
            }
        });
        new Label((Composite)shell, 0);
        Composite compProgressBar = new Composite((Composite)shell, 0);
        compProgressBar.setLayoutData((Object)new GridData(131072, 4, true, false, 1, 1));
        compProgressBar.setLayout((Layout)new GridLayout(1, false));
        this.progressBar = new ProgressBar(compProgressBar, 65536);
        this.progressBar.setLayoutData((Object)new GridData(131072, 128, false, false, 1, 1));
        this.progressBar.setVisible(false);
        shell.pack();
    }

    public static void updateChart() {
        ILineSeries lineSeries03;
        ILineSeries lineSeries02;
        Long numberOfDays;
        SimpleDateFormat format;
        IAxisTick xTick;
        ILineSeries lineSeries01;
        if (chart != null && !chart.isDisposed()) {
            chart.dispose();
        }
        chart = new Chart(containerChart, 0);
        chart.getTitle().setVisible(false);
        ILegend legend = chart.getLegend();
        legend.setVisible(false);
        IAxis xAxis = chart.getAxisSet().getXAxis(0);
        xAxis.getTitle().setVisible(false);
        xAxis.getTick().setForeground(new Color((Device)Display.getDefault(), 0, 0, 0));
        xAxis.getTick().setVisible(false);
        xAxis.getGrid().setVisible(false);
        int maxEnergy = DatabaseConnection.getMaxProfileValue(showLinesTotalEnergy, showLinesCommunityEnergy, showLinesNetworkEnergy, currentStartDate, currentEndDate);
        IAxis yAxis = chart.getAxisSet().getYAxis(0);
        yAxis.getTitle().setText(messages.getString("power"));
        yAxis.getTitle().setForeground(new Color((Device)Display.getDefault(), 0, 0, 0));
        yAxis.getTick().setForeground(new Color((Device)Display.getDefault(), 0, 0, 0));
        yAxis.getGrid().setStyle(LineStyle.SOLID);
        double maxPower = maxEnergy * 4;
        yAxis.setRange(new Range(0.0, maxPower));
        yAxis.getGrid().setStyle(LineStyle.SOLID);
        int axisId = chart.getAxisSet().createYAxis();
        IAxis yAxis2 = chart.getAxisSet().getYAxis(axisId);
        yAxis2.getTitle().setText(messages.getString("energy"));
        yAxis2.getTitle().setForeground(new Color((Device)Display.getDefault(), 0, 0, 0));
        yAxis2.getTick().setForeground(new Color((Device)Display.getDefault(), 0, 0, 0));
        yAxis2.getGrid().setVisible(false);
        yAxis2.setRange(new Range(0.0, (double)maxEnergy));
        yAxis2.setPosition(IAxis.Position.Secondary);
        for (Consumer consumer : consumers) {
            if (showLinesTotalEnergy.get(consumer.getPodNumber()).booleanValue()) {
                lineSeries01 = (ILineSeries)chart.getSeriesSet().createSeries(ISeries.SeriesType.LINE, String.valueOf(consumer.getName()) + " (C) - " + messages.getString("TotalEnergy"));
                lineSeries01.setYSeries(DatabaseConnection.getTotalEnergyDatas(consumer.getPodNumber(), currentStartDate, currentEndDate));
                lineSeries01.setSymbolType(ILineSeries.PlotSymbolType.NONE);
                lineSeries01.setLineStyle(LineStyle.SOLID);
                lineSeries01.setLineColor(consumer.getColor());
                lineSeries01.setLineWidth(2);
                lineSeries01.setXDateSeries(DatabaseConnection.getDatesOfEnergyDatas(currentStartDate, currentEndDate));
                xTick = xAxis.getTick();
                format = new SimpleDateFormat("   dd/MM/YYYY   ");
                numberOfDays = currentStartDate.until(currentEndDate, ChronoUnit.DAYS);
                if (numberOfDays == 0L) {
                    format = new SimpleDateFormat("      HH:mm     ");
                } else if (numberOfDays < 9L) {
                    format = new SimpleDateFormat("dd/MM/YYYY HH:mm");
                }
                xTick.setFormat((Format)format);
                xAxis.getTick().setVisible(true);
            }
            if (showLinesCommunityEnergy.get(consumer.getPodNumber()).booleanValue()) {
                lineSeries02 = (ILineSeries)chart.getSeriesSet().createSeries(ISeries.SeriesType.LINE, String.valueOf(consumer.getName()) + " (C) - " + messages.getString("EnergyFromCommunity"));
                lineSeries02.setYSeries(DatabaseConnection.getCommunityEnergyDatas(consumer.getPodNumber(), currentStartDate, currentEndDate));
                lineSeries02.setSymbolType(ILineSeries.PlotSymbolType.NONE);
                lineSeries02.setLineStyle(LineStyle.DASH);
                lineSeries02.setLineColor(consumer.getColor());
                lineSeries02.setLineWidth(2);
                lineSeries02.setXDateSeries(DatabaseConnection.getDatesOfEnergyDatas(currentStartDate, currentEndDate));
                xTick = xAxis.getTick();
                format = new SimpleDateFormat("   dd/MM/YYYY   ");
                numberOfDays = currentStartDate.until(currentEndDate, ChronoUnit.DAYS);
                if (numberOfDays == 0L) {
                    format = new SimpleDateFormat("      HH:mm     ");
                } else if (numberOfDays < 9L) {
                    format = new SimpleDateFormat("dd/MM/YYYY HH:mm");
                }
                xTick.setFormat((Format)format);
                xAxis.getTick().setVisible(true);
            }
            if (!showLinesNetworkEnergy.get(consumer.getPodNumber()).booleanValue()) continue;
            lineSeries03 = (ILineSeries)chart.getSeriesSet().createSeries(ISeries.SeriesType.LINE, String.valueOf(consumer.getName()) + " (C) - " + messages.getString("EnergyFromNetwork"));
            lineSeries03.setYSeries(DatabaseConnection.getNetworkEnergyDatas(consumer.getPodNumber(), currentStartDate, currentEndDate));
            lineSeries03.setSymbolType(ILineSeries.PlotSymbolType.NONE);
            lineSeries03.setLineStyle(LineStyle.DOT);
            lineSeries03.setLineColor(consumer.getColor());
            lineSeries03.setLineWidth(2);
            lineSeries03.setXDateSeries(DatabaseConnection.getDatesOfEnergyDatas(currentStartDate, currentEndDate));
            xTick = xAxis.getTick();
            format = new SimpleDateFormat("   dd/MM/YYYY   ");
            numberOfDays = currentStartDate.until(currentEndDate, ChronoUnit.DAYS);
            if (numberOfDays == 0L) {
                format = new SimpleDateFormat("      HH:mm     ");
            } else if (numberOfDays < 9L) {
                format = new SimpleDateFormat("dd/MM/YYYY HH:mm");
            }
            xTick.setFormat((Format)format);
            xAxis.getTick().setVisible(true);
        }
        for (Producer producer : producers) {
            if (showLinesTotalEnergy.get(producer.getPodNumber()).booleanValue()) {
                lineSeries01 = (ILineSeries)chart.getSeriesSet().createSeries(ISeries.SeriesType.LINE, String.valueOf(producer.getName()) + " (P) - " + messages.getString("TotalEnergy"));
                lineSeries01.setYSeries(DatabaseConnection.getTotalEnergyDatas(producer.getPodNumber(), currentStartDate, currentEndDate));
                lineSeries01.setSymbolType(ILineSeries.PlotSymbolType.NONE);
                lineSeries01.setLineStyle(LineStyle.SOLID);
                lineSeries01.setLineColor(producer.getColor());
                lineSeries01.setLineWidth(2);
                lineSeries01.setXDateSeries(DatabaseConnection.getDatesOfEnergyDatas(currentStartDate, currentEndDate));
                xTick = xAxis.getTick();
                format = new SimpleDateFormat("   dd/MM/YYYY   ");
                numberOfDays = currentStartDate.until(currentEndDate, ChronoUnit.DAYS);
                if (numberOfDays == 0L) {
                    format = new SimpleDateFormat("      HH:mm     ");
                } else if (numberOfDays < 9L) {
                    format = new SimpleDateFormat("dd/MM/YYYY HH:mm");
                }
                xTick.setFormat((Format)format);
                xAxis.getTick().setVisible(true);
            }
            if (showLinesCommunityEnergy.get(producer.getPodNumber()).booleanValue()) {
                lineSeries02 = (ILineSeries)chart.getSeriesSet().createSeries(ISeries.SeriesType.LINE, String.valueOf(producer.getName()) + " (P) - " + messages.getString("EnergyFromCommunity"));
                lineSeries02.setYSeries(DatabaseConnection.getCommunityEnergyDatas(producer.getPodNumber(), currentStartDate, currentEndDate));
                lineSeries02.setSymbolType(ILineSeries.PlotSymbolType.NONE);
                lineSeries02.setLineStyle(LineStyle.DASH);
                lineSeries02.setLineColor(producer.getColor());
                lineSeries02.setLineWidth(2);
                lineSeries02.setXDateSeries(DatabaseConnection.getDatesOfEnergyDatas(currentStartDate, currentEndDate));
                xTick = xAxis.getTick();
                format = new SimpleDateFormat("   dd/MM/YYYY   ");
                numberOfDays = currentStartDate.until(currentEndDate, ChronoUnit.DAYS);
                if (numberOfDays == 0L) {
                    format = new SimpleDateFormat("      HH:mm     ");
                } else if (numberOfDays < 9L) {
                    format = new SimpleDateFormat("dd/MM/YYYY HH:mm");
                }
                xTick.setFormat((Format)format);
                xAxis.getTick().setVisible(true);
            }
            if (!showLinesNetworkEnergy.get(producer.getPodNumber()).booleanValue()) continue;
            lineSeries03 = (ILineSeries)chart.getSeriesSet().createSeries(ISeries.SeriesType.LINE, String.valueOf(producer.getName()) + " (P) - " + messages.getString("EnergyFromNetwork"));
            lineSeries03.setYSeries(DatabaseConnection.getNetworkEnergyDatas(producer.getPodNumber(), currentStartDate, currentEndDate));
            lineSeries03.setSymbolType(ILineSeries.PlotSymbolType.NONE);
            lineSeries03.setLineStyle(LineStyle.DOT);
            lineSeries03.setLineColor(producer.getColor());
            lineSeries03.setLineWidth(2);
            lineSeries03.setXDateSeries(DatabaseConnection.getDatesOfEnergyDatas(currentStartDate, currentEndDate));
            xTick = xAxis.getTick();
            format = new SimpleDateFormat("   dd/MM/YYYY   ");
            numberOfDays = currentStartDate.until(currentEndDate, ChronoUnit.DAYS);
            if (numberOfDays == 0L) {
                format = new SimpleDateFormat("      HH:mm     ");
            } else if (numberOfDays < 9L) {
                format = new SimpleDateFormat("dd/MM/YYYY HH:mm");
            }
            xTick.setFormat((Format)format);
            xAxis.getTick().setVisible(true);
        }
        xAxis.adjustRange();
    }

    public static void updateTables() {
        Button checkButtonConsumerCommunity;
        Double consumersTotalEnergy = 0.0;
        Double consumersEnergyCommunity = 0.0;
        Double consumersEnergyNetwork = 0.0;
        tableConsumers.removeAll();
        Control[] controlArray = tableConsumers.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof Button) {
                control.dispose();
            }
            ++n2;
        }
        for (final Consumer consumer : consumers) {
            tableItem = new TableItem(tableConsumers, 0);
            TableEditor tableEditorCheckButtonConsumer = new TableEditor(tableConsumers);
            Button checkButtonConsumer = new Button((Composite)tableConsumers, 32);
            checkButtonConsumer.setSelection(showAllLines.get(consumer.getPodNumber()).booleanValue());
            checkButtonConsumer.pack();
            tableEditorCheckButtonConsumer.minimumWidth = checkButtonConsumer.getSize().x;
            tableEditorCheckButtonConsumer.horizontalAlignment = 0x1000000;
            tableEditorCheckButtonConsumer.setEditor((Control)checkButtonConsumer, tableItem, 0);
            tableItem.setData("allSelected", (Object)checkButtonConsumer);
            checkButtonConsumer.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    boolean found = false;
                    int i = 0;
                    while (!found && i < tableConsumers.getItemCount()) {
                        EnergeticCommunitiesSimulator.tableItem = tableConsumers.getItem(i);
                        if (tableItem.getData("allSelected") == (Button)e.getSource()) {
                            boolean selection = ((Button)e.getSource()).getSelection();
                            showAllLines.put(consumer.getPodNumber(), selection);
                            Button button = (Button)tableItem.getData("totalSelected");
                            button.setSelection(selection);
                            button.notifyListeners(13, new Event());
                            button = (Button)tableItem.getData("communitySelected");
                            if (button.getEnabled()) {
                                button.setSelection(selection);
                                button.notifyListeners(13, new Event());
                            }
                            if (!(button = (Button)tableItem.getData("networkSelected")).getEnabled()) break;
                            button.setSelection(selection);
                            button.notifyListeners(13, new Event());
                            break;
                        }
                        ++i;
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            TableEditor tableEditorCheckButtonConsumerTotal = new TableEditor(tableConsumers);
            Button checkButtonConsumerTotal = new Button((Composite)tableConsumers, 32);
            checkButtonConsumerTotal.setSelection(showLinesTotalEnergy.get(consumer.getPodNumber()).booleanValue());
            checkButtonConsumerTotal.pack();
            tableEditorCheckButtonConsumerTotal.minimumWidth = checkButtonConsumerTotal.getSize().x;
            tableEditorCheckButtonConsumerTotal.horizontalAlignment = 16384;
            tableEditorCheckButtonConsumerTotal.setEditor((Control)checkButtonConsumerTotal, tableItem, 2);
            tableItem.setData("totalSelected", (Object)checkButtonConsumerTotal);
            checkButtonConsumerTotal.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    int i = 0;
                    while (i < tableConsumers.getItemCount()) {
                        EnergeticCommunitiesSimulator.tableItem = tableConsumers.getItem(i);
                        if (tableItem.getData("totalSelected") == (Button)e.getSource()) {
                            boolean selection = ((Button)e.getSource()).getSelection();
                            if (!selection) {
                                showAllLines.put(consumer.getPodNumber(), selection);
                                Button button = (Button)tableItem.getData("allSelected");
                                button.setSelection(selection);
                            } else {
                                Button button = (Button)tableItem.getData("communitySelected");
                                if (button.getSelection() && (button = (Button)tableItem.getData("networkSelected")).getSelection()) {
                                    showAllLines.put(consumer.getPodNumber(), selection);
                                    button = (Button)tableItem.getData("allSelected");
                                    button.setSelection(selection);
                                }
                            }
                            showLinesTotalEnergy.put(consumer.getPodNumber(), selection);
                            EnergeticCommunitiesSimulator.updateChart();
                            break;
                        }
                        ++i;
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            TableEditor tableEditorCheckButtonConsumerCommunity = new TableEditor(tableConsumers);
            checkButtonConsumerCommunity = new Button((Composite)tableConsumers, 32);
            checkButtonConsumerCommunity.setSelection(showLinesCommunityEnergy.get(consumer.getPodNumber()).booleanValue());
            checkButtonConsumerCommunity.pack();
            tableEditorCheckButtonConsumerCommunity.minimumWidth = checkButtonConsumerCommunity.getSize().x;
            tableEditorCheckButtonConsumerCommunity.horizontalAlignment = 16384;
            tableEditorCheckButtonConsumerCommunity.setEditor((Control)checkButtonConsumerCommunity, tableItem, 3);
            tableItem.setData("communitySelected", (Object)checkButtonConsumerCommunity);
            checkButtonConsumerCommunity.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    int i = 0;
                    while (i < tableConsumers.getItemCount()) {
                        EnergeticCommunitiesSimulator.tableItem = tableConsumers.getItem(i);
                        if (tableItem.getData("communitySelected") == (Button)e.getSource()) {
                            boolean selection = ((Button)e.getSource()).getSelection();
                            if (!selection) {
                                showAllLines.put(consumer.getPodNumber(), selection);
                                Button button = (Button)tableItem.getData("allSelected");
                                button.setSelection(selection);
                            } else {
                                Button button = (Button)tableItem.getData("totalSelected");
                                if (button.getSelection() && (button = (Button)tableItem.getData("networkSelected")).getSelection()) {
                                    showAllLines.put(consumer.getPodNumber(), selection);
                                    button = (Button)tableItem.getData("allSelected");
                                    button.setSelection(selection);
                                }
                            }
                            showLinesCommunityEnergy.put(consumer.getPodNumber(), selection);
                            EnergeticCommunitiesSimulator.updateChart();
                            break;
                        }
                        ++i;
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            TableEditor tableEditorCheckButtonConsumerNetwork = new TableEditor(tableConsumers);
            Button checkButtonConsumerNetwork = new Button((Composite)tableConsumers, 32);
            checkButtonConsumerNetwork.setSelection(showLinesNetworkEnergy.get(consumer.getPodNumber()).booleanValue());
            checkButtonConsumerNetwork.pack();
            tableEditorCheckButtonConsumerNetwork.minimumWidth = checkButtonConsumerNetwork.getSize().x;
            tableEditorCheckButtonConsumerNetwork.horizontalAlignment = 16384;
            tableEditorCheckButtonConsumerNetwork.setEditor((Control)checkButtonConsumerNetwork, tableItem, 4);
            tableItem.setData("networkSelected", (Object)checkButtonConsumerNetwork);
            checkButtonConsumerNetwork.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    int i = 0;
                    while (i < tableConsumers.getItemCount()) {
                        EnergeticCommunitiesSimulator.tableItem = tableConsumers.getItem(i);
                        if (tableItem.getData("networkSelected") == (Button)e.getSource()) {
                            boolean selection = ((Button)e.getSource()).getSelection();
                            if (!selection) {
                                showAllLines.put(consumer.getPodNumber(), selection);
                                Button button = (Button)tableItem.getData("allSelected");
                                button.setSelection(selection);
                            } else {
                                Button button = (Button)tableItem.getData("totalSelected");
                                if (button.getSelection() && (button = (Button)tableItem.getData("communitySelected")).getSelection()) {
                                    showAllLines.put(consumer.getPodNumber(), selection);
                                    button = (Button)tableItem.getData("allSelected");
                                    button.setSelection(selection);
                                }
                            }
                            showLinesNetworkEnergy.put(consumer.getPodNumber(), selection);
                            EnergeticCommunitiesSimulator.updateChart();
                            break;
                        }
                        ++i;
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            tableItem.setText(1, consumer.getName());
            tableItem.setText(2, format.format(DatabaseConnection.getTotalEnergy(consumer.getPodNumber(), currentStartDate, currentEndDate)));
            consumersTotalEnergy = consumersTotalEnergy + DatabaseConnection.getTotalEnergy(consumer.getPodNumber(), currentStartDate, currentEndDate);
            Double energyCommunity = DatabaseConnection.getCommunityEnergy(consumer.getPodNumber(), currentStartDate, currentEndDate);
            if (DatabaseConnection.computationHasBeenPerformed()) {
                tableItem.setText(3, format.format(energyCommunity));
                consumersEnergyCommunity = consumersEnergyCommunity + energyCommunity;
            } else {
                checkButtonConsumerCommunity.setEnabled(false);
                checkButtonConsumerCommunity.setSelection(false);
                showLinesCommunityEnergy.put(consumer.getPodNumber(), false);
            }
            Double energyNetwork = DatabaseConnection.getNetworkEnergy(consumer.getPodNumber(), currentStartDate, currentEndDate);
            if (DatabaseConnection.computationHasBeenPerformed()) {
                tableItem.setText(4, format.format(energyNetwork));
                consumersEnergyNetwork = consumersEnergyNetwork + energyNetwork;
            } else {
                checkButtonConsumerNetwork.setEnabled(false);
                checkButtonConsumerNetwork.setSelection(false);
                showLinesNetworkEnergy.put(consumer.getPodNumber(), false);
            }
            tableItem.setBackground(5, consumer.getColor());
        }
        tableItem = new TableItem(tableConsumers, 0);
        tableItem.setText(1, messages.getString("TOTAL"));
        tableItem.setText(2, format.format(consumersTotalEnergy));
        if (DatabaseConnection.computationHasBeenPerformed()) {
            tableItem.setText(3, format.format(consumersEnergyCommunity));
            tableItem.setText(4, format.format(consumersEnergyNetwork));
        }
        Double producersTotalEnergy = 0.0;
        Double producersEnergyCommunity = 0.0;
        Double producersEnergyNetwork = 0.0;
        tableProducers.removeAll();
        checkButtonConsumerCommunity = tableProducers.getChildren();
        int tableEditorCheckButtonConsumerCommunity = ((Control[])checkButtonConsumerCommunity).length;
        int checkButtonConsumerTotal = 0;
        while (checkButtonConsumerTotal < tableEditorCheckButtonConsumerCommunity) {
            Control control = checkButtonConsumerCommunity[checkButtonConsumerTotal];
            if (control instanceof Button) {
                control.dispose();
            }
            ++checkButtonConsumerTotal;
        }
        for (final Producer producer : producers) {
            tableItem = new TableItem(tableProducers, 0);
            TableEditor tableEditorCheckButtonProducer = new TableEditor(tableProducers);
            Button checkButtonProducer = new Button((Composite)tableProducers, 32);
            checkButtonProducer.setSelection(showAllLines.get(producer.getPodNumber()).booleanValue());
            checkButtonProducer.pack();
            tableEditorCheckButtonProducer.minimumWidth = checkButtonProducer.getSize().x;
            tableEditorCheckButtonProducer.horizontalAlignment = 0x1000000;
            tableEditorCheckButtonProducer.setEditor((Control)checkButtonProducer, tableItem, 0);
            tableItem.setData("allSelected", (Object)checkButtonProducer);
            checkButtonProducer.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    boolean found = false;
                    int i = 0;
                    while (!found && i < tableProducers.getItemCount()) {
                        EnergeticCommunitiesSimulator.tableItem = tableProducers.getItem(i);
                        if (tableItem.getData("allSelected") == (Button)e.getSource()) {
                            boolean selection = ((Button)e.getSource()).getSelection();
                            showAllLines.put(producer.getPodNumber(), selection);
                            Button button = (Button)tableItem.getData("totalSelected");
                            button.setSelection(selection);
                            button.notifyListeners(13, new Event());
                            button = (Button)tableItem.getData("communitySelected");
                            if (button.getEnabled()) {
                                button.setSelection(selection);
                                button.notifyListeners(13, new Event());
                            }
                            if (!(button = (Button)tableItem.getData("networkSelected")).getEnabled()) break;
                            button.setSelection(selection);
                            button.notifyListeners(13, new Event());
                            break;
                        }
                        ++i;
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            TableEditor tableEditorCheckButtonProducerTotal = new TableEditor(tableProducers);
            Button checkButtonProducerTotal = new Button((Composite)tableProducers, 32);
            checkButtonProducerTotal.setSelection(showLinesTotalEnergy.get(producer.getPodNumber()).booleanValue());
            checkButtonProducerTotal.pack();
            tableEditorCheckButtonProducerTotal.minimumWidth = checkButtonProducerTotal.getSize().x;
            tableEditorCheckButtonProducerTotal.horizontalAlignment = 16384;
            tableEditorCheckButtonProducerTotal.setEditor((Control)checkButtonProducerTotal, tableItem, 2);
            tableItem.setData("totalSelected", (Object)checkButtonProducerTotal);
            checkButtonProducerTotal.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    int i = 0;
                    while (i < tableProducers.getItemCount()) {
                        EnergeticCommunitiesSimulator.tableItem = tableProducers.getItem(i);
                        if (tableItem.getData("totalSelected") == (Button)e.getSource()) {
                            boolean selection = ((Button)e.getSource()).getSelection();
                            if (!selection) {
                                showAllLines.put(producer.getPodNumber(), selection);
                                Button button = (Button)tableItem.getData("allSelected");
                                button.setSelection(selection);
                            } else {
                                Button button = (Button)tableItem.getData("communitySelected");
                                if (button.getSelection() && (button = (Button)tableItem.getData("networkSelected")).getSelection()) {
                                    showAllLines.put(producer.getPodNumber(), selection);
                                    button = (Button)tableItem.getData("allSelected");
                                    button.setSelection(selection);
                                }
                            }
                            showLinesTotalEnergy.put(producer.getPodNumber(), selection);
                            EnergeticCommunitiesSimulator.updateChart();
                            break;
                        }
                        ++i;
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            TableEditor tableEditorCheckButtonProducerCommunity = new TableEditor(tableProducers);
            Button checkButtonProducerCommunity = new Button((Composite)tableProducers, 32);
            checkButtonProducerCommunity.setSelection(showLinesCommunityEnergy.get(producer.getPodNumber()).booleanValue());
            checkButtonProducerCommunity.pack();
            tableEditorCheckButtonProducerCommunity.minimumWidth = checkButtonProducerCommunity.getSize().x;
            tableEditorCheckButtonProducerCommunity.horizontalAlignment = 16384;
            tableEditorCheckButtonProducerCommunity.setEditor((Control)checkButtonProducerCommunity, tableItem, 3);
            tableItem.setData("communitySelected", (Object)checkButtonProducerCommunity);
            checkButtonProducerCommunity.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    int i = 0;
                    while (i < tableProducers.getItemCount()) {
                        EnergeticCommunitiesSimulator.tableItem = tableProducers.getItem(i);
                        if (tableItem.getData("communitySelected") == (Button)e.getSource()) {
                            boolean selection = ((Button)e.getSource()).getSelection();
                            if (!selection) {
                                showAllLines.put(producer.getPodNumber(), selection);
                                Button button = (Button)tableItem.getData("allSelected");
                                button.setSelection(selection);
                            } else {
                                Button button = (Button)tableItem.getData("totalSelected");
                                if (button.getSelection() && (button = (Button)tableItem.getData("networkSelected")).getSelection()) {
                                    showAllLines.put(producer.getPodNumber(), selection);
                                    button = (Button)tableItem.getData("allSelected");
                                    button.setSelection(selection);
                                }
                            }
                            showLinesCommunityEnergy.put(producer.getPodNumber(), selection);
                            EnergeticCommunitiesSimulator.updateChart();
                            break;
                        }
                        ++i;
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            TableEditor tableEditorCheckButtonProducerNetwork = new TableEditor(tableProducers);
            Button checkButtonProducerNetwork = new Button((Composite)tableProducers, 32);
            checkButtonProducerNetwork.setSelection(showLinesNetworkEnergy.get(producer.getPodNumber()).booleanValue());
            checkButtonProducerNetwork.pack();
            tableEditorCheckButtonProducerNetwork.minimumWidth = checkButtonProducerNetwork.getSize().x;
            tableEditorCheckButtonProducerNetwork.horizontalAlignment = 16384;
            tableEditorCheckButtonProducerNetwork.setEditor((Control)checkButtonProducerNetwork, tableItem, 4);
            tableItem.setData("networkSelected", (Object)checkButtonProducerNetwork);
            checkButtonProducerNetwork.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    int i = 0;
                    while (i < tableProducers.getItemCount()) {
                        EnergeticCommunitiesSimulator.tableItem = tableProducers.getItem(i);
                        if (tableItem.getData("networkSelected") == (Button)e.getSource()) {
                            boolean selection = ((Button)e.getSource()).getSelection();
                            if (!selection) {
                                showAllLines.put(producer.getPodNumber(), selection);
                                Button button = (Button)tableItem.getData("allSelected");
                                button.setSelection(selection);
                            } else {
                                Button button = (Button)tableItem.getData("totalSelected");
                                if (button.getSelection() && (button = (Button)tableItem.getData("communitySelected")).getSelection()) {
                                    showAllLines.put(producer.getPodNumber(), selection);
                                    button = (Button)tableItem.getData("allSelected");
                                    button.setSelection(selection);
                                }
                            }
                            showLinesNetworkEnergy.put(producer.getPodNumber(), selection);
                            EnergeticCommunitiesSimulator.updateChart();
                            break;
                        }
                        ++i;
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            tableItem.setText(1, producer.getName());
            tableItem.setText(2, format.format(DatabaseConnection.getTotalEnergy(producer.getPodNumber(), currentStartDate, currentEndDate)));
            producersTotalEnergy = producersTotalEnergy + DatabaseConnection.getTotalEnergy(producer.getPodNumber(), currentStartDate, currentEndDate);
            Double energyCommunity = DatabaseConnection.getCommunityEnergy(producer.getPodNumber(), currentStartDate, currentEndDate);
            if (DatabaseConnection.computationHasBeenPerformed()) {
                tableItem.setText(3, format.format(energyCommunity));
                producersEnergyCommunity = producersEnergyCommunity + energyCommunity;
            } else {
                checkButtonProducerCommunity.setEnabled(false);
                checkButtonProducerCommunity.setSelection(false);
                showLinesCommunityEnergy.put(producer.getPodNumber(), false);
            }
            Double energyNetwork = DatabaseConnection.getNetworkEnergy(producer.getPodNumber(), currentStartDate, currentEndDate);
            if (DatabaseConnection.computationHasBeenPerformed()) {
                tableItem.setText(4, format.format(energyNetwork));
                producersEnergyNetwork = producersEnergyNetwork + energyNetwork;
            } else {
                checkButtonProducerNetwork.setEnabled(false);
                checkButtonProducerNetwork.setSelection(false);
                showLinesNetworkEnergy.put(producer.getPodNumber(), false);
            }
            tableItem.setBackground(5, producer.getColor());
        }
        tableItem = new TableItem(tableProducers, 0);
        tableItem.setText(1, messages.getString("TOTAL"));
        tableItem.setText(2, format.format(producersTotalEnergy));
        if (DatabaseConnection.computationHasBeenPerformed()) {
            tableItem.setText(3, format.format(producersEnergyCommunity));
            tableItem.setText(4, format.format(producersEnergyNetwork));
        }
    }

    public static void updateDates() {
        currentStartDate = DatabaseConnection.getOldestStartDate().toLocalDate();
        currentEndDate = DatabaseConnection.getLatestEndDate().toLocalDate();
        lblStartDate.setText(currentStartDate.format(dateFormatter));
        lblEndDate.setText(currentEndDate.format(dateFormatter));
    }

    public static void addConsumerOrProducer(String podNumber) {
        showAllLines.put(podNumber, false);
        showLinesTotalEnergy.put(podNumber, false);
        showLinesCommunityEnergy.put(podNumber, false);
        showLinesNetworkEnergy.put(podNumber, false);
    }

    public static void removeConsumerOrProducer(String podNumber) {
        showAllLines.remove(podNumber);
        showLinesTotalEnergy.remove(podNumber);
        showLinesCommunityEnergy.remove(podNumber);
        showLinesNetworkEnergy.remove(podNumber);
    }
}

