/*
 * Decompiled with CFR 0.152.
 */
package ui;

import java.util.ArrayList;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class CustomMessageBox
extends Dialog {
    private static final int FORM_SPACING = 5;
    private static final String OK_CAPTION = "Ok";
    private static final int SCREEN_MINIMUM = 20;
    private Shell ivParentShell;
    private Shell ivShell;
    private Composite ivCompositeImage;
    private Composite ivCompositeMessage;
    private Composite ivCompositeDummy;
    private Composite ivCompositeButtons;
    private Label ivLabelImage;
    private Label ivLabelMessage;
    private Color ivMessageForegroundColor;
    private Color ivMessageBackgroundColor;
    private Font ivMessageFont;
    private ImageCode ivImageCode;
    private String ivTitle;
    private String ivMessage;
    private ArrayList<ButtonParameter> ivButtons;
    private int ivResult;

    public CustomMessageBox(Shell parentShell, ImageCode imageCode, String title, String message) {
        super(parentShell, 67680);
        this.ivParentShell = parentShell;
        this.ivImageCode = imageCode;
        this.ivTitle = title;
        this.ivMessage = message;
        this.ivButtons = new ArrayList();
        this.ivMessageForegroundColor = null;
        this.ivMessageBackgroundColor = null;
        this.ivMessageFont = null;
    }

    public void addButton(String caption, int result) {
        this.addButton(caption, result, false);
    }

    public void addButton(String caption, int result, boolean isDefault) {
        this.ivButtons.add(new ButtonParameter(caption, result, isDefault));
    }

    public void setMessageForegroundColor(Color foregroundColor) {
        this.ivMessageForegroundColor = foregroundColor;
    }

    public void setMessageBackgroundColor(Color backgroundColor) {
        this.ivMessageBackgroundColor = backgroundColor;
    }

    public void setMessageFont(Font font) {
        this.ivMessageFont = font;
    }

    public int getResult() {
        Display display = Display.getDefault();
        if (this.ivButtons.size() == 0) {
            this.addButton(OK_CAPTION, 0, true);
        }
        this.ivShell = new Shell(67616);
        this.createContents(display);
        this.ivShell.pack();
        this.ivShell.setSize(800, 200);
        this.ivShell.setLocation(this.centerOnParent(this.ivParentShell, this.ivShell));
        this.ivShell.open();
        while (!this.ivShell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.ivResult;
    }

    private Point centerOnParent(Shell parentShell, Shell childShell) {
        Rectangle parent = parentShell.getBounds();
        Rectangle child = childShell.getBounds();
        int x = (int)((float)parent.x + (float)(parent.width - child.width) * 0.5f);
        int y = (int)((float)parent.y + (float)(parent.height - child.height) * 0.5f);
        if (x < 20) {
            x = 20;
        }
        if (y < 20) {
            y = 20;
        }
        return new Point(x, y);
    }

    private void createContents(Display display) {
        this.ivShell.setLayout((Layout)new GridLayout(2, false));
        this.ivShell.setText(this.ivTitle);
        this.ivCompositeImage = new Composite((Composite)this.ivShell, 0);
        FormLayout formLayout = new FormLayout();
        formLayout.marginLeft = 20;
        formLayout.marginRight = 20;
        this.ivCompositeImage.setLayout((Layout)formLayout);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 128;
        gridData.horizontalAlignment = 16384;
        this.ivCompositeImage.setLayoutData((Object)gridData);
        this.ivCompositeMessage = new Composite((Composite)this.ivShell, 0);
        this.ivCompositeMessage.setLayout((Layout)new FormLayout());
        gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.ivCompositeMessage.setLayoutData((Object)gridData);
        this.ivCompositeDummy = new Composite((Composite)this.ivShell, 0);
        this.ivCompositeDummy.setLayout((Layout)new FormLayout());
        this.ivCompositeButtons = new Composite((Composite)this.ivShell, 0);
        this.ivCompositeButtons.setLayout((Layout)new FormLayout());
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 0x1000008;
        this.ivCompositeButtons.setLayoutData((Object)gridData);
        this.ivLabelImage = new Label(this.ivCompositeImage, 0);
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.left = new FormAttachment(0, 0);
        this.ivLabelImage.setLayoutData((Object)formData);
        this.ivLabelImage.setImage(display.getSystemImage(this.ivImageCode.getImageCode()));
        this.ivLabelMessage = new Label(this.ivCompositeMessage, 64);
        formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.bottom = new FormAttachment(100, 0);
        this.ivLabelMessage.setLayoutData((Object)formData);
        this.ivLabelMessage.setText(String.valueOf(this.ivMessage) + System.getProperty("line.separator") + " ");
        if (this.ivMessageForegroundColor != null) {
            this.ivLabelMessage.setForeground(this.ivMessageForegroundColor);
        }
        if (this.ivMessageBackgroundColor != null) {
            this.ivLabelMessage.setBackground(this.ivMessageBackgroundColor);
        }
        if (this.ivMessageFont != null) {
            this.ivLabelMessage.setFont(this.ivMessageFont);
        }
        Button lastButton = null;
        for (ButtonParameter parm : this.ivButtons) {
            Button button = new Button(this.ivCompositeButtons, 8);
            formData = new FormData();
            formData.right = lastButton == null ? new FormAttachment(100, -5) : new FormAttachment(lastButton, -5, 16384);
            formData.bottom = new FormAttachment(100, -5);
            button.setLayoutData((Object)formData);
            button.setText("  " + parm.getCaption() + "  ");
            button.addMouseListener((MouseListener)new ButtonMouseListener(parm.getResult()));
            lastButton = button;
            if (!parm.isDefault()) continue;
            this.ivShell.setDefaultButton(button);
        }
        if (this.ivShell.getDefaultButton() == null) {
            this.ivShell.setDefaultButton(lastButton);
        }
    }

    private class ButtonMouseListener
    extends MouseAdapter {
        private int ivButtonResult;

        private ButtonMouseListener(int result) {
            this.ivButtonResult = result;
        }

        public void mouseUp(MouseEvent e) {
            CustomMessageBox.this.ivResult = this.ivButtonResult;
            CustomMessageBox.this.ivShell.close();
        }
    }

    private class ButtonParameter {
        private String ivCaption;
        private int ivResult;
        private boolean ivIsDefault;

        private ButtonParameter(String caption, int result, boolean isDefault) {
            this.ivCaption = caption;
            this.ivResult = result;
            this.ivIsDefault = isDefault;
        }

        private String getCaption() {
            return this.ivCaption;
        }

        private int getResult() {
            return this.ivResult;
        }

        private boolean isDefault() {
            return this.ivIsDefault;
        }
    }

    public static enum ImageCode {
        INFORMATION(2),
        QUESTION(4),
        WARNING(8),
        ERROR(1);

        private int ivImageCode;

        private ImageCode(int imageCode) {
            this.ivImageCode = imageCode;
        }

        private int getImageCode() {
            return this.ivImageCode;
        }
    }
}

