/*
 * Decompiled with CFR 0.152.
 */
package ui;

import db.DatabaseConnection;
import importation.Import;
import java.io.FileReader;
import java.io.Reader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.wb.swt.SWTResourceManager;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import persistance.Producer;
import ui.EnergeticCommunitiesSimulator;

public class AddProducer {
    private static final String configFile = "config.ini";
    private static Locale currentLocale;
    private static ResourceBundle messages;
    private Shell shell;
    private static int width;
    private static int height;
    private Text tName;
    private Text tFile;
    private static Iterator<Producer> itProducers;
    private static DateFormat dateFormat;
    private static Producer newProducer;
    private Preferences prefs = Preferences.userRoot().node(this.getClass().getName());
    private static String LAST_USED_FOLDER;

    static {
        width = 700;
        height = 250;
        LAST_USED_FOLDER = "";
    }

    public AddProducer(final Shell mainShell, final ArrayList<Producer> producers, final Tree treeProducers, final Button btnCompute, final Button btnKeyConfiguration, final Button btnExportResults, final ProgressBar progressBar) {
        String language = "en";
        try {
            FileReader reader = new FileReader(configFile);
            JSONParser jsonParser = new JSONParser();
            JSONObject configObject = (JSONObject)jsonParser.parse((Reader)reader);
            language = (String)configObject.get((Object)"language");
            dateFormat = language.equals("en") ? new SimpleDateFormat("dd-MM-yyyy") : new SimpleDateFormat("dd-MM-yyyy");
        }
        catch (Exception reader) {
            // empty catch block
        }
        currentLocale = new Locale(language, "");
        messages = ResourceBundle.getBundle("languages", currentLocale);
        this.shell = new Shell(mainShell, 65536);
        this.shell.setSize(width, height);
        this.shell.setText(messages.getString("addProducer"));
        this.shell.setLayout((Layout)new GridLayout(3, false));
        Label shellTitle = new Label((Composite)this.shell, 0);
        shellTitle.setAlignment(0x1000000);
        shellTitle.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 3, 1));
        shellTitle.setText(messages.getString("addTitle"));
        final Label lblError = new Label((Composite)this.shell, 0);
        lblError.setAlignment(0x1000000);
        lblError.setForeground(SWTResourceManager.getColor(3));
        GridData gd_lblError = new GridData(0x1000000, 0x1000000, true, false, 3, 1);
        gd_lblError.heightHint = 56;
        lblError.setLayoutData((Object)gd_lblError);
        Label lblName = new Label((Composite)this.shell, 0);
        lblName.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblName.setText(messages.getString("name"));
        this.tName = new Text((Composite)this.shell, 2048);
        GridData gdTName = new GridData(16384, 0x1000000, false, false, 2, 1);
        gdTName.widthHint = 280;
        this.tName.setLayoutData((Object)gdTName);
        this.tName.addListener(1, new Listener(){

            public void handleEvent(Event arg0) {
                lblError.setText("");
                lblError.setVisible(false);
                AddProducer.this.shell.layout();
            }
        });
        Label lblIssuer = new Label((Composite)this.shell, 0);
        lblIssuer.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblIssuer.setText(messages.getString("fileIssuer"));
        final Combo comboIssuer = new Combo((Composite)this.shell, 8);
        GridData gd_comboIssuer = new GridData(4, 0x1000000, false, false, 2, 1);
        gd_comboIssuer.widthHint = 275;
        comboIssuer.setLayoutData((Object)gd_comboIssuer);
        String[] issuers = new String[]{"Leneda", messages.getString("formatILR")};
        comboIssuer.setItems(issuers);
        comboIssuer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                lblError.setText("");
                lblError.setVisible(false);
                AddProducer.this.shell.layout();
            }
        });
        Label lblFile = new Label((Composite)this.shell, 0);
        lblFile.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblFile.setText(messages.getString("loadCurveFile"));
        this.tFile = new Text((Composite)this.shell, 2048);
        this.tFile.setEnabled(false);
        GridData gdTFile = new GridData(4, 0x1000000, false, false, 1, 1);
        gdTFile.widthHint = 181;
        this.tFile.setLayoutData((Object)gdTFile);
        Button btnOpenDialog = new Button((Composite)this.shell, 0);
        btnOpenDialog.setText("...");
        class SelectFile
        implements SelectionListener {
            private final /* synthetic */ Label val$lblError;

            SelectFile(Label label) {
                this.val$lblError = label;
            }

            public void widgetSelected(SelectionEvent e) {
                this.val$lblError.setText("");
                this.val$lblError.setVisible(false);
                AddProducer.this.shell.layout();
                FileDialog fd = new FileDialog(AddProducer.this.shell, 4096);
                fd.setText("Open");
                fd.setFilterPath(AddProducer.this.prefs.get(LAST_USED_FOLDER, ""));
                String[] filterExt = new String[]{"*.csv;*.xlsx"};
                fd.setFilterExtensions(filterExt);
                String selected = fd.open();
                if (selected != null) {
                    AddProducer.this.tFile.setText(selected);
                    String selectedFileName = fd.getFileName();
                    String lastUsedFolder = selected = selected.substring(0, selected.length() - (selectedFileName.length() + 1));
                    AddProducer.this.prefs.put(LAST_USED_FOLDER, lastUsedFolder);
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        }
        btnOpenDialog.addSelectionListener((SelectionListener)new SelectFile(lblError));
        new Label((Composite)this.shell, 0);
        new Label((Composite)this.shell, 0);
        new Label((Composite)this.shell, 0);
        new Label((Composite)this.shell, 0);
        Button btnCancel = new Button((Composite)this.shell, 0);
        btnCancel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        btnCancel.setText(messages.getString("cancel"));
        btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddProducer.this.shell.setVisible(false);
                AddProducer.this.shell.dispose();
            }
        });
        Button btnValidate = new Button((Composite)this.shell, 0);
        btnValidate.setText(messages.getString("ok"));
        btnValidate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                block23: {
                    try {
                        if (AddProducer.this.tName.getText().isEmpty()) {
                            lblError.setText(messages.getString("errorAddProducerEmptyName"));
                            lblError.setVisible(true);
                            AddProducer.this.shell.layout();
                            break block23;
                        }
                        Boolean producerExists = false;
                        itProducers = producers.iterator();
                        while (itProducers.hasNext() && !producerExists.booleanValue()) {
                            Producer currentProducer = (Producer)itProducers.next();
                            if (!currentProducer.getName().equals(AddProducer.this.tName.getText())) continue;
                            producerExists = true;
                        }
                        if (producerExists.booleanValue()) {
                            lblError.setText(messages.getString("errorAddProducerDuplicateName"));
                            lblError.setVisible(true);
                            AddProducer.this.shell.layout();
                            break block23;
                        }
                        if (comboIssuer.getText().isEmpty()) {
                            lblError.setText(messages.getString("errorAddProducerIssuerNotSelected"));
                            lblError.setVisible(true);
                            AddProducer.this.shell.layout();
                            break block23;
                        }
                        if (AddProducer.this.tFile.getText().isEmpty()) {
                            lblError.setText(messages.getString("errorAddConsumerFileNotSelected"));
                            lblError.setVisible(true);
                            AddProducer.this.shell.layout();
                            break block23;
                        }
                        Boolean error = false;
                        DatabaseConnection.startTransaction();
                        String name = AddProducer.this.tName.getText().trim();
                        switch (comboIssuer.getText()) {
                            case "Leneda": {
                                try {
                                    newProducer = Import.readProducerLeneda(name, AddProducer.this.tFile.getText(), progressBar);
                                }
                                catch (Exception exception) {
                                    if (exception instanceof Import.DuplicatePODException) {
                                        lblError.setText(messages.getString("errorAddProducerDuplicatePOD"));
                                    } else {
                                        lblError.setText(messages.getString("errorAddProducerFileFormat"));
                                    }
                                    lblError.setVisible(true);
                                    progressBar.setVisible(false);
                                    AddProducer.this.shell.layout();
                                    error = true;
                                }
                                break;
                            }
                            default: {
                                try {
                                    newProducer = Import.readProducerILR(name, AddProducer.this.tFile.getText(), progressBar);
                                    break;
                                }
                                catch (Exception exception) {
                                    if (exception instanceof Import.DuplicatePODException) {
                                        lblError.setText(messages.getString("errorAddProducerDuplicatePOD"));
                                    } else {
                                        lblError.setText(messages.getString("errorAddProducerFileFormat"));
                                    }
                                    lblError.setVisible(true);
                                    progressBar.setVisible(false);
                                    AddProducer.this.shell.layout();
                                    error = true;
                                }
                            }
                        }
                        DatabaseConnection.closeTransaction(error);
                        if (!error.booleanValue()) {
                            producers.add(newProducer);
                            TreeItem treeProducerItem0 = new TreeItem(treeProducers, 0);
                            treeProducerItem0.setText(newProducer.getName());
                            TreeItem treeProducerItem01 = new TreeItem(treeProducerItem0, 0);
                            treeProducerItem01.setText(String.valueOf(messages.getString("startDate")) + ": " + dateFormat.format(newProducer.getStartDate()));
                            TreeItem treeProducerItem02 = new TreeItem(treeProducerItem0, 0);
                            treeProducerItem02.setText(String.valueOf(messages.getString("endDate")) + ": " + dateFormat.format(newProducer.getEndDate()));
                            TreeItem treeProducerItem03 = new TreeItem(treeProducerItem0, 0);
                            treeProducerItem03.setText(String.valueOf(messages.getString("priority")) + ": " + (newProducer.getPriority() == 0 ? "" : Integer.valueOf(newProducer.getPriority())));
                            DatabaseConnection.deleteComputation();
                            EnergeticCommunitiesSimulator.addConsumerOrProducer(newProducer.getPodNumber());
                            EnergeticCommunitiesSimulator.updateDates();
                            EnergeticCommunitiesSimulator.updateTables();
                            EnergeticCommunitiesSimulator.updateChart();
                            mainShell.open();
                            mainShell.layout();
                            btnCompute.setEnabled(DatabaseConnection.computationCanBePerformed());
                            btnKeyConfiguration.setEnabled(DatabaseConnection.consumerAndProducerDefined());
                            btnExportResults.setEnabled(DatabaseConnection.computationHasBeenPerformed());
                            AddProducer.this.shell.setVisible(false);
                            AddProducer.this.shell.dispose();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        new Label((Composite)this.shell, 0);
        Label lblNewLabel = new Label((Composite)this.shell, 0);
        GridData gd_lblNewLabel = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblNewLabel.widthHint = 25;
        lblNewLabel.setLayoutData((Object)gd_lblNewLabel);
        new Label((Composite)this.shell, 0);
        this.shell.pack();
    }

    public void open() {
        this.shell.open();
    }

    public void close() {
        this.shell.setVisible(false);
    }
}

