/*
 * Decompiled with CFR 0.152.
 */
package ui;

import db.DatabaseConnection;
import importation.Import;
import java.io.FileReader;
import java.io.Reader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.wb.swt.SWTResourceManager;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import persistance.Consumer;
import ui.EnergeticCommunitiesSimulator;

public class AddConsumer {
    private static final String configFile = "config.ini";
    private static Locale currentLocale;
    private static ResourceBundle messages;
    private Shell shell;
    private static int width;
    private static int height;
    private Text tName;
    private Text tFile;
    private static Iterator<Consumer> itConsumers;
    protected static DateFormat dateFormat;
    private static Consumer newConsumer;
    private Preferences prefs = Preferences.userRoot().node(this.getClass().getName());
    private static String LAST_USED_FOLDER;

    static {
        width = 700;
        height = 250;
        LAST_USED_FOLDER = "";
    }

    public AddConsumer(final Shell mainShell, final ArrayList<Consumer> consumers, final Tree treeConsumers, final Button btnCompute, final Button btnKeyConfiguration, final Button btnExportResults, final ProgressBar progressBar) {
        String language = "en";
        try {
            FileReader reader = new FileReader(configFile);
            JSONParser jsonParser = new JSONParser();
            JSONObject configObject = (JSONObject)jsonParser.parse((Reader)reader);
            language = (String)configObject.get((Object)"language");
            dateFormat = new SimpleDateFormat("dd-MM-yyyy");
            if (language.equals("en")) {
                dateFormat = new SimpleDateFormat("dd-MM-yyyy");
            }
        }
        catch (Exception reader) {
            // empty catch block
        }
        currentLocale = new Locale(language, "");
        messages = ResourceBundle.getBundle("languages", currentLocale);
        this.shell = new Shell(mainShell, 65536);
        this.shell.setSize(width, height);
        this.shell.setLayout((Layout)new GridLayout(3, false));
        Label shellTitle = new Label((Composite)this.shell, 0);
        shellTitle.setAlignment(0x1000000);
        shellTitle.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 3, 1));
        shellTitle.setText(messages.getString("addTitle"));
        final Label lblError = new Label((Composite)this.shell, 0);
        lblError.setAlignment(0x1000000);
        lblError.setForeground(SWTResourceManager.getColor(3));
        GridData gd_lblError = new GridData(0x1000000, 0x1000000, true, false, 3, 1);
        gd_lblError.heightHint = 56;
        lblError.setLayoutData((Object)gd_lblError);
        Label lblName = new Label((Composite)this.shell, 0);
        lblName.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblName.setText(messages.getString("name"));
        this.tName = new Text((Composite)this.shell, 2048);
        GridData gdTName = new GridData(16384, 0x1000000, false, false, 2, 1);
        gdTName.widthHint = 280;
        this.tName.setLayoutData((Object)gdTName);
        this.tName.addListener(1, new Listener(){

            public void handleEvent(Event arg0) {
                lblError.setText("");
                lblError.setVisible(false);
                AddConsumer.this.shell.layout();
            }
        });
        Label lblIssuer = new Label((Composite)this.shell, 0);
        lblIssuer.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblIssuer.setText(messages.getString("fileIssuer"));
        final Combo comboIssuer = new Combo((Composite)this.shell, 8);
        GridData gd_comboIssuer = new GridData(4, 0x1000000, false, false, 2, 1);
        gd_comboIssuer.widthHint = 275;
        comboIssuer.setLayoutData((Object)gd_comboIssuer);
        String[] issuers = new String[]{"Leneda", messages.getString("formatILR")};
        comboIssuer.setItems(issuers);
        comboIssuer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                lblError.setText("");
                lblError.setVisible(false);
                AddConsumer.this.shell.layout();
            }
        });
        Label lblFile = new Label((Composite)this.shell, 0);
        lblFile.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblFile.setText(messages.getString("loadCurveFile"));
        this.tFile = new Text((Composite)this.shell, 2048);
        this.tFile.setEnabled(false);
        GridData gdTFile = new GridData(4, 0x1000000, false, false, 1, 1);
        gdTFile.widthHint = 181;
        this.tFile.setLayoutData((Object)gdTFile);
        Button btnOpenDialog = new Button((Composite)this.shell, 0);
        btnOpenDialog.setText("...");
        class SelectFile
        implements SelectionListener {
            private final /* synthetic */ Label val$lblError;

            SelectFile(Label label) {
                this.val$lblError = label;
            }

            public void widgetSelected(SelectionEvent e) {
                this.val$lblError.setText("");
                this.val$lblError.setVisible(false);
                AddConsumer.this.shell.layout();
                FileDialog fd = new FileDialog(AddConsumer.this.shell, 4096);
                fd.setText("Open");
                fd.setFilterPath(AddConsumer.this.prefs.get(LAST_USED_FOLDER, ""));
                String[] filterExt = new String[]{"*.csv;*.xlsx"};
                fd.setFilterExtensions(filterExt);
                String selected = fd.open();
                if (selected != null) {
                    AddConsumer.this.tFile.setText(selected);
                    String selectedFileName = fd.getFileName();
                    String lastUsedFolder = selected = selected.substring(0, selected.length() - (selectedFileName.length() + 1));
                    AddConsumer.this.prefs.put(LAST_USED_FOLDER, lastUsedFolder);
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        }
        btnOpenDialog.addSelectionListener((SelectionListener)new SelectFile(lblError));
        new Label((Composite)this.shell, 0);
        new Label((Composite)this.shell, 0);
        new Label((Composite)this.shell, 0);
        new Label((Composite)this.shell, 0);
        Button btnCancel = new Button((Composite)this.shell, 0);
        btnCancel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        btnCancel.setText(messages.getString("cancel"));
        btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddConsumer.this.shell.setVisible(false);
                AddConsumer.this.shell.dispose();
            }
        });
        Button btnValidate = new Button((Composite)this.shell, 0);
        btnValidate.setText(messages.getString("ok"));
        btnValidate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                block23: {
                    try {
                        if (AddConsumer.this.tName.getText().isEmpty()) {
                            lblError.setText(messages.getString("errorAddConsumerEmptyName"));
                            lblError.setVisible(true);
                            AddConsumer.this.shell.layout();
                            break block23;
                        }
                        Boolean consumerExists = false;
                        itConsumers = consumers.iterator();
                        while (itConsumers.hasNext() && !consumerExists.booleanValue()) {
                            Consumer currentConsumer = (Consumer)itConsumers.next();
                            if (!currentConsumer.getName().equals(AddConsumer.this.tName.getText())) continue;
                            consumerExists = true;
                        }
                        if (consumerExists.booleanValue()) {
                            lblError.setText(messages.getString("errorAddConsumerDuplicateName"));
                            lblError.setVisible(true);
                            AddConsumer.this.shell.layout();
                            break block23;
                        }
                        if (comboIssuer.getText().isEmpty()) {
                            lblError.setText(messages.getString("errorAddConsumerIssuerNotSelected"));
                            lblError.setVisible(true);
                            AddConsumer.this.shell.layout();
                            break block23;
                        }
                        if (AddConsumer.this.tFile.getText().isEmpty()) {
                            lblError.setText(messages.getString("errorAddConsumerFileNotSelected"));
                            lblError.setVisible(true);
                            AddConsumer.this.shell.layout();
                            break block23;
                        }
                        Boolean error = false;
                        DatabaseConnection.startTransaction();
                        String name = AddConsumer.this.tName.getText().trim();
                        switch (comboIssuer.getText()) {
                            case "Leneda": {
                                try {
                                    newConsumer = Import.readConsumerLeneda(name, AddConsumer.this.tFile.getText(), progressBar);
                                }
                                catch (Exception exception) {
                                    if (exception instanceof Import.DuplicatePODException) {
                                        lblError.setText(messages.getString("errorAddConsumerDuplicatePOD"));
                                    } else {
                                        lblError.setText(messages.getString("errorAddConsumerFileFormat"));
                                    }
                                    lblError.setVisible(true);
                                    progressBar.setVisible(false);
                                    AddConsumer.this.shell.layout();
                                    error = true;
                                }
                                break;
                            }
                            default: {
                                try {
                                    newConsumer = Import.readConsumerILR(name, AddConsumer.this.tFile.getText(), progressBar);
                                    break;
                                }
                                catch (Exception exception) {
                                    if (exception instanceof Import.DuplicatePODException) {
                                        lblError.setText(messages.getString("errorAddConsumerDuplicatePOD"));
                                    } else {
                                        lblError.setText(messages.getString("errorAddConsumerFileFormat"));
                                    }
                                    lblError.setVisible(true);
                                    progressBar.setVisible(false);
                                    AddConsumer.this.shell.layout();
                                    error = true;
                                }
                            }
                        }
                        DatabaseConnection.closeTransaction(error);
                        if (!error.booleanValue()) {
                            consumers.add(newConsumer);
                            TreeItem treeConsumerItem0 = new TreeItem(treeConsumers, 0, treeConsumers.getItems().length);
                            treeConsumerItem0.setText(newConsumer.getName());
                            TreeItem treeConsumerItem01 = new TreeItem(treeConsumerItem0, 0);
                            treeConsumerItem01.setText(String.valueOf(messages.getString("startDate")) + ": " + dateFormat.format(newConsumer.getStartDate()));
                            TreeItem treeConsumerItem02 = new TreeItem(treeConsumerItem0, 0);
                            treeConsumerItem02.setText(String.valueOf(messages.getString("endDate")) + ": " + dateFormat.format(newConsumer.getEndDate()));
                            TreeItem treeConsumerItem03 = new TreeItem(treeConsumerItem0, 0);
                            treeConsumerItem03.setText(String.valueOf(messages.getString("priority")) + ": " + (newConsumer.getPriority() == 0 ? "" : Integer.valueOf(newConsumer.getPriority())));
                            TreeItem treeConsumerItem04 = new TreeItem(treeConsumerItem0, 0);
                            treeConsumerItem04.setText(String.valueOf(messages.getString("percentage")) + ": " + (newConsumer.getPercentage() == 0 ? "" : Integer.valueOf(newConsumer.getPercentage())));
                            TreeItem treeConsumerItem05 = new TreeItem(treeConsumerItem0, 0);
                            treeConsumerItem05.setText(String.valueOf(messages.getString("prorata")) + ": " + (newConsumer.getProrata() == 0 ? messages.getString("disabled") : messages.getString("enabled")));
                            DatabaseConnection.deleteComputation();
                            EnergeticCommunitiesSimulator.addConsumerOrProducer(newConsumer.getPodNumber());
                            EnergeticCommunitiesSimulator.updateDates();
                            EnergeticCommunitiesSimulator.updateTables();
                            EnergeticCommunitiesSimulator.updateChart();
                            AddConsumer.this.shell.setVisible(false);
                            AddConsumer.this.shell.dispose();
                            mainShell.open();
                            mainShell.layout();
                            btnCompute.setEnabled(DatabaseConnection.computationCanBePerformed());
                            btnKeyConfiguration.setEnabled(DatabaseConnection.consumerAndProducerDefined());
                            btnExportResults.setEnabled(DatabaseConnection.computationHasBeenPerformed());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        new Label((Composite)this.shell, 0);
        Label lblNewLabel = new Label((Composite)this.shell, 0);
        GridData gd_lblNewLabel = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblNewLabel.widthHint = 25;
        lblNewLabel.setLayoutData((Object)gd_lblNewLabel);
        new Label((Composite)this.shell, 0);
        this.shell.pack();
    }

    public void open() {
        this.shell.open();
    }

    public void close() {
        this.shell.setVisible(false);
    }
}

