/*
 * Decompiled with CFR 0.152.
 */
package importation;

import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import db.DatabaseConnection;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Date;
import java.sql.Time;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.eclipse.swt.widgets.ProgressBar;
import persistance.Consumer;
import persistance.ConsumptionData;
import persistance.Producer;
import persistance.ProductionData;

public final class Import {
    protected static DatabaseConnection databaseConnection;

    private Import() {
        throw new UnsupportedOperationException();
    }

    public static Consumer readConsumerLeneda(String consumerName, String fileName, ProgressBar progressBar) throws Exception {
        progressBar.setVisible(true);
        FileReader fileReader = new FileReader(fileName);
        CSVReader csvReader = new CSVReaderBuilder((Reader)fileReader).withSkipLines(1).build();
        List allData = csvReader.readAll();
        String strStartDate = ((String[])allData.get(0))[2];
        Date startDate = Date.valueOf(strStartDate.substring(0, 10));
        Time startTime = Time.valueOf(strStartDate.substring(11, 19));
        String strEndDate = ((String[])allData.get(allData.size() - 1))[2];
        Date endDate = Date.valueOf(strEndDate.substring(0, 10));
        Time endTime = Time.valueOf(strEndDate.substring(11, 19));
        String podNumber = ((String[])allData.get(0))[0];
        if (DatabaseConnection.podNumberExists(podNumber)) {
            csvReader.close();
            throw new DuplicatePODException("This POD number is already defined");
        }
        Consumer newConsumer = new Consumer(podNumber, consumerName, startDate, startTime, endDate, endTime, 0, 0, 1, DatabaseConnection.getFirstUnusedConsumerColor());
        DatabaseConnection.addConsumer(newConsumer);
        Double value = 0.0;
        int currentRecord = 1;
        int recordsCount = allData.size();
        for (String[] row : allData) {
            String strDate = row[2];
            Date date = Date.valueOf(strDate.substring(0, 10));
            Time time = Time.valueOf(strDate.substring(11, 19));
            value = Double.parseDouble(row[3]) / 4.0;
            ConsumptionData consumptionData = new ConsumptionData(podNumber, date, time, value);
            DatabaseConnection.addConsumptionData(consumptionData);
            progressBar.setMaximum(recordsCount);
            progressBar.setSelection(currentRecord);
            ++currentRecord;
        }
        csvReader.close();
        DatabaseConnection.updateConsumer(newConsumer);
        progressBar.setVisible(false);
        return newConsumer;
    }

    public static Producer readProducerLeneda(String producerName, String fileName, ProgressBar progressBar) throws Exception {
        progressBar.setVisible(true);
        FileReader fileReader = new FileReader(fileName);
        CSVReader csvReader = new CSVReaderBuilder((Reader)fileReader).withSkipLines(1).build();
        List allData = csvReader.readAll();
        String strStartDate = ((String[])allData.get(0))[2];
        Date startDate = Date.valueOf(strStartDate.substring(0, 10));
        Time startTime = Time.valueOf(strStartDate.substring(11, 19));
        String strEndDate = ((String[])allData.get(allData.size() - 1))[2];
        Date endDate = Date.valueOf(strEndDate.substring(0, 10));
        Time endTime = Time.valueOf(strEndDate.substring(11, 19));
        String podNumber = ((String[])allData.get(0))[0];
        if (DatabaseConnection.podNumberExists(podNumber)) {
            csvReader.close();
            throw new DuplicatePODException("This POD number is already defined");
        }
        Producer newProducer = new Producer(podNumber, producerName, startDate, startTime, endDate, endTime, 0, DatabaseConnection.getFirstUnusedProducerColor());
        DatabaseConnection.addProducer(newProducer);
        Double value = 0.0;
        int currentRecord = 1;
        int recordsCount = allData.size();
        for (String[] row : allData) {
            String strDate = row[2];
            Date date = Date.valueOf(strDate.substring(0, 10));
            Time time = Time.valueOf(strDate.substring(11, 19));
            value = Double.parseDouble(row[3]) / 4.0;
            ProductionData productionData = new ProductionData(podNumber, date, time, value);
            DatabaseConnection.addProductionData(productionData);
            progressBar.setMaximum(recordsCount);
            progressBar.setSelection(currentRecord);
            ++currentRecord;
        }
        csvReader.close();
        DatabaseConnection.updateProducer(newProducer);
        progressBar.setVisible(false);
        return newProducer;
    }

    public static Consumer readConsumerILR(String consumerName, String fileName, ProgressBar progressBar) throws Exception {
        progressBar.setVisible(true);
        FileInputStream inputStream = new FileInputStream(fileName);
        XSSFWorkbook workbook = new XSSFWorkbook((InputStream)inputStream);
        XSSFSheet sheet = workbook.getSheetAt(0);
        DataFormatter df = new DataFormatter();
        XSSFRow rowStart = sheet.getRow(2);
        String podNumber = rowStart.getCell(1).getStringCellValue();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String strStartDate = simpleDateFormat.format(rowStart.getCell(3).getDateCellValue());
        Date startDate = Date.valueOf(strStartDate);
        Time startTime = Time.valueOf(df.formatCellValue(rowStart.getCell(4)));
        XSSFRow rowEnd = sheet.getRow(sheet.getLastRowNum());
        String strEndDate = simpleDateFormat.format(rowEnd.getCell(3).getDateCellValue());
        Date endDate = Date.valueOf(strEndDate);
        Time endTime = Time.valueOf(df.formatCellValue(rowEnd.getCell(4)));
        if (DatabaseConnection.podNumberExists(podNumber)) {
            workbook.close();
            throw new DuplicatePODException("This POD number is already defined");
        }
        Consumer newConsumer = new Consumer(podNumber, consumerName, startDate, startTime, endDate, endTime, 0, 0, 1, DatabaseConnection.getFirstUnusedConsumerColor());
        DatabaseConnection.addConsumer(newConsumer);
        Iterator rowIterator = sheet.iterator();
        Date date = new Date(0L);
        Time time = new Time(0L);
        Double value = 0.0;
        int currentRecord = 1;
        int recordsCount = sheet.getLastRowNum() - 2;
        while (rowIterator.hasNext()) {
            Row row = (Row)rowIterator.next();
            if (row.getRowNum() <= 1) continue;
            Iterator cellIterator = row.cellIterator();
            while (cellIterator.hasNext()) {
                Cell cell = (Cell)cellIterator.next();
                switch (cell.getColumnIndex()) {
                    case 3: {
                        String strDate = simpleDateFormat.format(cell.getDateCellValue());
                        date = Date.valueOf(strDate);
                        break;
                    }
                    case 4: {
                        time = Time.valueOf(df.formatCellValue(cell));
                        break;
                    }
                    case 5: {
                        String strValue = df.formatCellValue(cell);
                        value = Double.parseDouble(strValue.replace(",", ".")) / 4.0;
                        break;
                    }
                }
            }
            ConsumptionData consumptionData = new ConsumptionData(podNumber, date, time, value);
            DatabaseConnection.addConsumptionData(consumptionData);
            progressBar.setMaximum(recordsCount);
            progressBar.setSelection(currentRecord);
            ++currentRecord;
        }
        workbook.close();
        DatabaseConnection.updateConsumer(newConsumer);
        progressBar.setVisible(false);
        return newConsumer;
    }

    public static Producer readProducerILR(String producerName, String fileName, ProgressBar progressBar) throws Exception {
        progressBar.setVisible(true);
        FileInputStream inputStream = new FileInputStream(fileName);
        XSSFWorkbook workbook = new XSSFWorkbook((InputStream)inputStream);
        XSSFSheet sheet = workbook.getSheetAt(0);
        DataFormatter df = new DataFormatter();
        XSSFRow rowStart = sheet.getRow(2);
        String podNumber = rowStart.getCell(1).getStringCellValue();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String strStartDate = simpleDateFormat.format(rowStart.getCell(3).getDateCellValue());
        Date startDate = Date.valueOf(strStartDate);
        Time startTime = Time.valueOf(df.formatCellValue(rowStart.getCell(4)));
        XSSFRow rowEnd = sheet.getRow(sheet.getLastRowNum());
        String strEndDate = simpleDateFormat.format(rowEnd.getCell(3).getDateCellValue());
        Date endDate = Date.valueOf(strEndDate);
        Time endTime = Time.valueOf(df.formatCellValue(rowEnd.getCell(4)));
        if (DatabaseConnection.podNumberExists(podNumber)) {
            workbook.close();
            throw new DuplicatePODException("This POD number is already defined");
        }
        Producer newProducer = new Producer(podNumber, producerName, startDate, startTime, endDate, endTime, 0, DatabaseConnection.getFirstUnusedProducerColor());
        DatabaseConnection.addProducer(newProducer);
        Iterator rowIterator = sheet.iterator();
        Date date = new Date(0L);
        Time time = new Time(0L);
        Double value = 0.0;
        int currentRecord = 1;
        int recordsCount = sheet.getLastRowNum() - 2;
        while (rowIterator.hasNext()) {
            Row row = (Row)rowIterator.next();
            if (row.getRowNum() <= 2) continue;
            Iterator cellIterator = row.cellIterator();
            while (cellIterator.hasNext()) {
                Cell cell = (Cell)cellIterator.next();
                switch (cell.getColumnIndex()) {
                    case 3: {
                        String strDate = simpleDateFormat.format(cell.getDateCellValue());
                        date = Date.valueOf(strDate);
                        break;
                    }
                    case 4: {
                        time = Time.valueOf(df.formatCellValue(cell));
                        break;
                    }
                    case 5: {
                        String strValue = df.formatCellValue(cell);
                        value = Double.parseDouble(strValue.replace(",", ".")) / 4.0;
                        break;
                    }
                }
            }
            ProductionData productionData = new ProductionData(podNumber, date, time, value);
            DatabaseConnection.addProductionData(productionData);
            progressBar.setMaximum(recordsCount);
            progressBar.setSelection(currentRecord);
            ++currentRecord;
        }
        workbook.close();
        DatabaseConnection.updateProducer(newProducer);
        progressBar.setVisible(false);
        return newProducer;
    }

    public static class DuplicatePODException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public DuplicatePODException(String errorMessage) {
            super(errorMessage);
        }
    }
}

