/*
 * Decompiled with CFR 0.152.
 */
package exportation;

import com.opencsv.CSVWriterBuilder;
import com.opencsv.ICSVWriter;
import db.DatabaseConnection;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import persistance.Consumer;
import persistance.Producer;

public final class Export {
    private static final String configFile = "config.ini";
    private static Locale currentLocale;
    private static ResourceBundle messages;
    private static DecimalFormat format;
    private static DateTimeFormatter dateFormat;
    protected static ArrayList<Consumer> consumers;
    private static Iterator<Consumer> itConsumers;
    protected static ArrayList<Producer> producers;
    private static Iterator<Producer> itProducers;

    private Export() {
        throw new UnsupportedOperationException();
    }

    public static void exportAsCSV(Shell shell, LocalDate startDate, LocalDate endDate, String filename) {
        String name22;
        Object podNumber;
        String language = "en";
        try {
            FileReader reader = new FileReader(configFile);
            JSONParser jsonParser = new JSONParser();
            JSONObject configObject = (JSONObject)jsonParser.parse((Reader)reader);
            language = (String)configObject.get((Object)"language");
        }
        catch (Exception reader) {
            // empty catch block
        }
        currentLocale = new Locale(language, "");
        messages = ResourceBundle.getBundle("languages", currentLocale);
        dateFormat = currentLocale.getLanguage().equals("en") ? DateTimeFormatter.ofPattern("dd.MM.yyyy") : DateTimeFormatter.ofPattern("dd.MM.yyyy");
        format = new DecimalFormat("###,##0.00");
        DecimalFormatSymbols s = format.getDecimalFormatSymbols();
        s.setGroupingSeparator(' ');
        s.setDecimalSeparator(',');
        format.setDecimalFormatSymbols(s);
        ArrayList<String[]> csvData = new ArrayList<String[]>();
        String[] lineDate = new String[]{messages.getString("from"), startDate.format(dateFormat), messages.getString("to"), endDate.format(dateFormat), "", "", ""};
        csvData.add(lineDate);
        String[] lineConsumers = new String[]{messages.getString("consumers"), "", "", "", "", "", "", ""};
        csvData.add(lineConsumers);
        String[] headerConsumers = new String[]{messages.getString("PODNumber"), messages.getString("name"), messages.getString("priority"), messages.getString("percentage"), messages.getString("prorata"), messages.getString("TotalEnergy"), messages.getString("EnergyFromCommunity"), messages.getString("EnergyFromNetwork")};
        csvData.add(headerConsumers);
        consumers = DatabaseConnection.getAllConsumers();
        Double consumersTotalEnergy = 0.0;
        Double consumersEnergyCommunity = 0.0;
        Double consumersEnergyNetwork = 0.0;
        for (Consumer consumer : consumers) {
            String podNumber2 = consumer.getPodNumber();
            String name = consumer.getName();
            String priority = String.valueOf(consumer.getPriority());
            String percentage = String.valueOf(consumer.getPercentage());
            String prorata = "";
            if (consumer.getProrata() == 1) {
                prorata = "x";
            }
            Double totalEnergy = DatabaseConnection.getTotalEnergy(consumer.getPodNumber(), startDate, endDate);
            Double energyCommunity = DatabaseConnection.getCommunityEnergy(consumer.getPodNumber(), startDate, endDate);
            Double energyNetwork = DatabaseConnection.getNetworkEnergy(consumer.getPodNumber(), startDate, endDate);
            String sTotalEnergy = format.format(totalEnergy);
            String sEnergyCommunity = format.format(energyCommunity);
            String sEnergyNetwork = format.format(energyNetwork);
            String[] lineConsumer = new String[]{podNumber2, name, priority, percentage, prorata, sTotalEnergy, sEnergyCommunity, sEnergyNetwork};
            csvData.add(lineConsumer);
            consumersTotalEnergy = consumersTotalEnergy + DatabaseConnection.getTotalEnergy(consumer.getPodNumber(), startDate, endDate);
            consumersEnergyCommunity = consumersEnergyCommunity + energyCommunity;
            consumersEnergyNetwork = consumersEnergyNetwork + energyNetwork;
        }
        String[] lineTotalConsumers = new String[]{messages.getString("TOTAL"), "", "", "", "", format.format(consumersTotalEnergy), format.format(consumersEnergyCommunity), format.format(consumersEnergyNetwork)};
        csvData.add(lineTotalConsumers);
        String[] lineProducers = new String[]{messages.getString("producers"), "", "", "", "", "", "", ""};
        csvData.add(lineProducers);
        String[] headerProducers = new String[]{messages.getString("PODNumber"), messages.getString("name"), messages.getString("priority"), "", "", messages.getString("TotalEnergy"), messages.getString("EnergyToCommunity"), messages.getString("EnergyToNetwork")};
        csvData.add(headerProducers);
        producers = DatabaseConnection.getAllProducers();
        Double producersTotalEnergy = 0.0;
        Double producersEnergyCommunity = 0.0;
        Double producersEnergyNetwork = 0.0;
        for (Producer producer : producers) {
            podNumber = producer.getPodNumber();
            name22 = producer.getName();
            String priority = String.valueOf(producer.getPriority());
            Double totalEnergy = DatabaseConnection.getTotalEnergy(producer.getPodNumber(), startDate, endDate);
            Double energyCommunity = DatabaseConnection.getCommunityEnergy(producer.getPodNumber(), startDate, endDate);
            Double energyNetwork = DatabaseConnection.getNetworkEnergy(producer.getPodNumber(), startDate, endDate);
            String sTotalEnergy = format.format(totalEnergy);
            String sEnergyCommunity = format.format(energyCommunity);
            String sEnergyNetwork = format.format(energyNetwork);
            String[] lineProducer = new String[]{podNumber, name22, priority, "", "", sTotalEnergy, sEnergyCommunity, sEnergyNetwork};
            csvData.add(lineProducer);
            producersTotalEnergy = producersTotalEnergy + DatabaseConnection.getTotalEnergy(producer.getPodNumber(), startDate, endDate);
            producersEnergyCommunity = producersEnergyCommunity + energyCommunity;
            producersEnergyNetwork = producersEnergyNetwork + energyNetwork;
        }
        String[] lineTotalProducers = new String[]{messages.getString("TOTAL"), "", "", "", "", format.format(producersTotalEnergy), format.format(producersEnergyCommunity), format.format(producersEnergyNetwork)};
        csvData.add(lineTotalProducers);
        try {
            podNumber = null;
            name22 = null;
            try (ICSVWriter writer = new CSVWriterBuilder((Writer)new FileWriter(filename)).withSeparator(',').build();){
                writer.writeAll(csvData);
                MessageBox successMessageBox = new MessageBox(shell, 34);
                successMessageBox.setMessage(String.valueOf(messages.getString("successExportResults")) + " " + filename);
                successMessageBox.open();
            }
            catch (Throwable name22) {
                if (podNumber == null) {
                    podNumber = name22;
                } else if (podNumber != name22) {
                    ((Throwable)podNumber).addSuppressed(name22);
                }
                throw podNumber;
            }
        }
        catch (Exception e) {
            MessageBox errorMessageBox = new MessageBox(shell, 33);
            errorMessageBox.setMessage(messages.getString("errorExportResults"));
            errorMessageBox.open();
        }
    }
}

