/*
 * Decompiled with CFR 0.152.
 */
package db;

import java.io.File;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.time.DateUtils;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import persistance.Consumer;
import persistance.ConsumptionData;
import persistance.ConsumptionDataAfterSharing;
import persistance.PDateTime;
import persistance.Producer;
import persistance.ProductionData;
import persistance.ProductionDataAfterSharing;

public class DatabaseConnection {
    private static final String home = System.getProperty("user.home");
    private static final String dbPath = String.valueOf(home) + "/Documents/WeShareEnergy";
    private static Connection connection = null;
    private static Statement statement = null;
    private static DateTimeFormatter dateTimeFormat;

    public DatabaseConnection() {
        throw new UnsupportedOperationException();
    }

    public static void connect() {
        boolean dbExists = true;
        try {
            File file = new File(dbPath);
            if (!file.exists()) {
                file.mkdir();
                dbExists = false;
            }
            Class.forName("org.sqlite.JDBC");
            connection = DriverManager.getConnection("jdbc:sqlite:" + dbPath + "/ecs.db");
            statement = connection.createStatement();
            statement.executeUpdate("VACUUM;");
            if (!dbExists) {
                DatabaseConnection.createDatabase();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        dateTimeFormat = DateTimeFormatter.ofPattern("HH:mm:ss");
    }

    public static void close() {
        try {
            statement.close();
            connection.close();
            connection = DriverManager.getConnection("jdbc:sqlite:" + dbPath);
            statement = connection.createStatement();
            statement.executeUpdate("VACUUM;");
            statement.close();
            connection.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void startTransaction() {
        try {
            connection.setAutoCommit(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void closeTransaction(boolean error) {
        try {
            if (!error) {
                connection.commit();
            } else {
                connection.rollback();
            }
            connection.setAutoCommit(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static ResultSet query(String request) {
        ResultSet resultSet = null;
        try {
            resultSet = statement.executeQuery(request);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return resultSet;
    }

    public static void addConsumer(Consumer consumer) {
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO `consumers` VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            preparedStatement.setString(1, consumer.getPodNumber());
            preparedStatement.setString(2, consumer.getName());
            preparedStatement.setString(3, consumer.getStartDate().toString());
            preparedStatement.setString(4, consumer.getStartTime().toString());
            preparedStatement.setString(5, consumer.getEndDate().toString());
            preparedStatement.setString(6, consumer.getEndTime().toString());
            preparedStatement.setInt(7, consumer.getPriority());
            preparedStatement.setInt(8, consumer.getPercentage());
            preparedStatement.setInt(9, consumer.getProrata());
            preparedStatement.setString(10, String.valueOf(consumer.getColor().getRed()) + "," + consumer.getColor().getGreen() + "," + consumer.getColor().getBlue());
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void updateConsumer(Consumer consumer) {
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("UPDATE `consumers` SET `priority` = ?, `percentage` = ?, `prorata` = ? WHERE `pod-number` = ?");
            preparedStatement.setInt(1, consumer.getPriority());
            preparedStatement.setInt(2, consumer.getPercentage());
            preparedStatement.setInt(3, consumer.getProrata());
            preparedStatement.setString(4, consumer.getPodNumber());
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static ArrayList<Consumer> getAllConsumers() {
        ArrayList<Consumer> consumers = new ArrayList<Consumer>();
        try {
            ResultSet resultSet = DatabaseConnection.query("SELECT `pod-number`, `name`, `start-date`, `start-time`, `end-date`, `end-time`, `priority`, `percentage`, `prorata`, `rgb` FROM `consumers` ORDER BY `name` ASC");
            while (resultSet.next()) {
                consumers.add(new Consumer(resultSet.getString("pod-number"), resultSet.getString("name"), resultSet.getString("start-date"), resultSet.getString("start-time"), resultSet.getString("end-date"), resultSet.getString("end-time"), resultSet.getString("priority"), resultSet.getString("percentage"), resultSet.getString("prorata"), resultSet.getString("rgb")));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return consumers;
    }

    public static HashMap<Integer, ArrayList<Consumer>> getPriorityConsumersByPriority() {
        HashMap<Integer, ArrayList<Consumer>> priorityConsumers = new HashMap<Integer, ArrayList<Consumer>>();
        try {
            ResultSet resultSet = DatabaseConnection.query("SELECT `pod-number`, `name`, `start-date`, `start-time`, `end-date`, `end-time`, `priority`, `percentage`, `prorata`, `rgb` FROM `consumers` WHERE `priority` != 0 ORDER BY `priority` ASC");
            int priority = 0;
            ArrayList<Consumer> consumers = new ArrayList<Consumer>();
            while (resultSet.next()) {
                int consumerPriority = Integer.parseInt(resultSet.getString("priority"));
                if (consumerPriority > priority) {
                    if (priority != 0) {
                        priorityConsumers.put(priority, consumers);
                    }
                    priority = consumerPriority;
                    consumers = new ArrayList();
                }
                consumers.add(new Consumer(resultSet.getString("pod-number"), resultSet.getString("name"), resultSet.getString("start-date"), resultSet.getString("start-time"), resultSet.getString("end-date"), resultSet.getString("end-time"), resultSet.getString("priority"), resultSet.getString("percentage"), resultSet.getString("prorata"), resultSet.getString("rgb")));
            }
            if (priority != 0) {
                priorityConsumers.put(priority, consumers);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return priorityConsumers;
    }

    public static ArrayList<Consumer> getPercentageConsumers() {
        ArrayList<Consumer> consumers = new ArrayList<Consumer>();
        try {
            ResultSet resultSet = DatabaseConnection.query("SELECT `pod-number`, `name`, `start-date`, `start-time`, `end-date`, `end-time`,  `priority`, `percentage`, `prorata`, `rgb` FROM `consumers` WHERE `percentage` != 0");
            while (resultSet.next()) {
                consumers.add(new Consumer(resultSet.getString("pod-number"), resultSet.getString("name"), resultSet.getString("start-date"), resultSet.getString("start-time"), resultSet.getString("end-date"), resultSet.getString("end-time"), resultSet.getString("priority"), resultSet.getString("percentage"), resultSet.getString("prorata"), resultSet.getString("rgb")));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return consumers;
    }

    public static void removeConsumer(String podNumber) {
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT `rgb` FROM `consumers` WHERE `pod-number` = ?");
            preparedStatement.setString(1, podNumber);
            ResultSet resultSet = preparedStatement.executeQuery();
            resultSet.next();
            String rgb = resultSet.getString(1);
            preparedStatement = connection.prepareStatement("UPDATE `colorsConsumers` SET `used` = 0 WHERE `rgb` = ?");
            preparedStatement.setString(1, rgb);
            preparedStatement.executeUpdate();
            preparedStatement = connection.prepareStatement("DELETE FROM `consumers` WHERE `pod-number` = ?");
            preparedStatement.setString(1, podNumber);
            preparedStatement.executeUpdate();
            DatabaseConnection.truncateConsumptionDataConsumer(podNumber);
            DatabaseConnection.truncateConsumptionDataAfterSharing();
            DatabaseConnection.truncateProductionDataAfterSharing();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static String getConsumerPodNumber(String name) {
        String podNumber = "";
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT `pod-number` FROM `consumers` WHERE `name` = ? LIMIT 1");
            preparedStatement.setString(1, name);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                return resultSet.getString("pod-number");
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return podNumber;
    }

    public static void removeAllConsumers() {
        try {
            statement.execute("DELETE FROM `consumers`");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void addProducer(Producer producer) {
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO `producers` VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
            preparedStatement.setString(1, producer.getPodNumber());
            preparedStatement.setString(2, producer.getName());
            preparedStatement.setString(3, producer.getStartDate().toString());
            preparedStatement.setString(4, producer.getStartTime().toString());
            preparedStatement.setString(5, producer.getEndDate().toString());
            preparedStatement.setString(6, producer.getEndTime().toString());
            preparedStatement.setInt(7, producer.getPriority());
            preparedStatement.setString(8, String.valueOf(producer.getColor().getRed()) + "," + producer.getColor().getGreen() + "," + producer.getColor().getBlue());
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void updateProducer(Producer producer) {
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("UPDATE `producers` SET `priority` = ? WHERE `pod-number` = ?");
            preparedStatement.setInt(1, producer.getPriority());
            preparedStatement.setString(2, producer.getPodNumber());
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static ArrayList<Producer> getAllProducers() {
        ArrayList<Producer> producers = new ArrayList<Producer>();
        try {
            ResultSet resultSet = DatabaseConnection.query("SELECT `pod-number`, `name`, `start-date`, `start-time`, `end-date`, `end-time`, `priority`, `rgb` FROM `producers` ORDER BY `name` ASC");
            while (resultSet.next()) {
                producers.add(new Producer(resultSet.getString("pod-number"), resultSet.getString("name"), resultSet.getString("start-date"), resultSet.getString("start-time"), resultSet.getString("end-date"), resultSet.getString("end-time"), resultSet.getString("priority"), resultSet.getString("rgb")));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return producers;
    }

    public static HashMap<Integer, ArrayList<Producer>> getPriorityProducersByPriority() {
        HashMap<Integer, ArrayList<Producer>> priorityProducers = new HashMap<Integer, ArrayList<Producer>>();
        try {
            ResultSet resultSet = DatabaseConnection.query("SELECT `pod-number`, `name`, `start-date`, `start-time`, `end-date`, `end-time`, `priority`, `rgb` FROM `producers` WHERE `priority` != 0 ORDER BY `priority` ASC");
            int priority = 0;
            ArrayList<Producer> producers = new ArrayList<Producer>();
            while (resultSet.next()) {
                int producerPriority = Integer.parseInt(resultSet.getString("priority"));
                if (producerPriority > priority) {
                    if (priority != 0) {
                        priorityProducers.put(priority, producers);
                    }
                    priority = producerPriority;
                    producers = new ArrayList();
                }
                producers.add(new Producer(resultSet.getString("pod-number"), resultSet.getString("name"), resultSet.getString("start-date"), resultSet.getString("start-time"), resultSet.getString("end-date"), resultSet.getString("end-time"), resultSet.getString("priority"), resultSet.getString("rgb")));
            }
            if (priority != 0) {
                priorityProducers.put(priority, producers);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return priorityProducers;
    }

    public static ArrayList<Producer> getNonPriorityProducers() {
        ArrayList<Producer> producers = new ArrayList<Producer>();
        try {
            ResultSet resultSet = DatabaseConnection.query("SELECT `pod-number`, `name`, `start-date`, `start-time`, `end-date`, `end-time`, `priority`, `rgb` FROM `producers` WHERE `priority` == 0 ORDER BY `priority` ASC");
            while (resultSet.next()) {
                producers.add(new Producer(resultSet.getString("pod-number"), resultSet.getString("name"), resultSet.getString("start-date"), resultSet.getString("start-time"), resultSet.getString("end-date"), resultSet.getString("end-time"), resultSet.getString("priority"), resultSet.getString("rgb")));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return producers;
    }

    public static void removeProducer(String podNumber) {
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT `rgb` FROM `producers` WHERE `pod-number` = ?");
            preparedStatement.setString(1, podNumber);
            ResultSet resultSet = preparedStatement.executeQuery();
            resultSet.next();
            String rgb = resultSet.getString(1);
            preparedStatement = connection.prepareStatement("UPDATE `colorsProducers` SET `used` = 0 WHERE `rgb` = ?");
            preparedStatement.setString(1, rgb);
            preparedStatement.executeUpdate();
            preparedStatement = connection.prepareStatement("DELETE FROM `producers` WHERE `pod-number` = ?");
            preparedStatement.setString(1, podNumber);
            preparedStatement.executeUpdate();
            DatabaseConnection.truncateProductionDataProducer(podNumber);
            DatabaseConnection.truncateConsumptionDataAfterSharing();
            DatabaseConnection.truncateProductionDataAfterSharing();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static String getProducerPodNumber(String name) {
        String podNumber = "";
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT `pod-number` FROM `producers` WHERE `name` = ? LIMIT 1");
            preparedStatement.setString(1, name);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                return resultSet.getString("pod-number");
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return podNumber;
    }

    public static void removeAllProducers() {
        try {
            statement.execute("DELETE FROM `producers`");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void addConsumptionData(ConsumptionData consumptionData) {
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT `profileValue` FROM `consumptionData` WHERE `consumer_pod-number` = ? AND `date` = ? AND `startTime` = ? LIMIT 1");
            preparedStatement.setString(1, consumptionData.getConsumerPodNumber());
            preparedStatement.setString(2, consumptionData.getDate().toString());
            preparedStatement.setString(3, consumptionData.getStartTime().toString());
            ResultSet resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) {
                PreparedStatement preparedStatementInsert = connection.prepareStatement("INSERT INTO `consumptionData` VALUES (?, ?, ?, ?)");
                preparedStatementInsert.setString(1, consumptionData.getConsumerPodNumber());
                preparedStatementInsert.setString(2, consumptionData.getDate().toString());
                preparedStatementInsert.setString(3, consumptionData.getStartTime().toString());
                preparedStatementInsert.setDouble(4, consumptionData.getProfileValue());
                preparedStatementInsert.executeUpdate();
            } else {
                Double existingProfileValue = resultSet.getDouble("profileValue");
                PreparedStatement preparedStatementUpdate = connection.prepareStatement("UPDATE `consumptionData` SET `profileValue` = ? WHERE  `consumer_pod-number` = ? AND `date` = ? AND `startTime` = ?");
                preparedStatementUpdate.setDouble(1, consumptionData.getProfileValue() + existingProfileValue);
                preparedStatementUpdate.setString(2, consumptionData.getConsumerPodNumber());
                preparedStatementUpdate.setString(3, consumptionData.getDate().toString());
                preparedStatementUpdate.setString(4, consumptionData.getStartTime().toString());
                preparedStatementUpdate.executeUpdate();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static Double getConsumptionData(Consumer consumer, Date date, Time time) {
        Double returnValue = 0.0;
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT `profileValue` FROM `consumptionData` WHERE `consumer_pod-number` = ? AND `date` = ? AND `startTime` = ? LIMIT 1");
            preparedStatement.setString(1, consumer.getPodNumber());
            preparedStatement.setString(2, date.toString());
            preparedStatement.setString(3, time.toString());
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                returnValue = resultSet.getDouble("profileValue");
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return returnValue;
    }

    public static HashMap<Consumer, Double> getConsumptionData(ArrayList<Consumer> consumers, Date date, Time time) {
        HashMap<Consumer, Double> returnValue = new HashMap<Consumer, Double>();
        for (Consumer consumer : consumers) {
            try {
                PreparedStatement preparedStatement = connection.prepareStatement("SELECT `profileValue` FROM `consumptionData` WHERE `consumer_pod-number` = ? AND `date` = ? AND `startTime` = ?");
                preparedStatement.setString(1, consumer.getPodNumber());
                preparedStatement.setString(2, date.toString());
                preparedStatement.setString(3, time.toString());
                ResultSet resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    returnValue.put(consumer, resultSet.getDouble("profileValue"));
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return returnValue;
    }

    public static void truncateConsumptionDataConsumer(String consumerPodNumber) {
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("DELETE FROM `consumptionData` WHERE `consumer_pod-number` = ?");
            preparedStatement.setString(1, consumerPodNumber);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void truncateConsumptionData() {
        try {
            statement.execute("DELETE FROM `consumptionData`");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void addConsumptionDataAfterSharing(ConsumptionDataAfterSharing consumptionDataAfterSharing) {
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO `consumptionDataAfterSharing` VALUES (?, ?, ?, ?, ?)");
            preparedStatement.setString(1, consumptionDataAfterSharing.getConsumerPodNumber());
            preparedStatement.setString(2, consumptionDataAfterSharing.getDate().toString());
            preparedStatement.setString(3, consumptionDataAfterSharing.getStartTime().toString());
            preparedStatement.setDouble(4, consumptionDataAfterSharing.getEnergyCommunity());
            preparedStatement.setDouble(5, consumptionDataAfterSharing.getEnergyNetwork());
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void truncateConsumptionDataAfterSharing() {
        try {
            statement.execute("DELETE FROM `consumptionDataAfterSharing`");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void addProductionData(ProductionData productionData) {
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT `profileValue` FROM `productionData` WHERE `producer_pod-number` = ? AND `date` = ? AND `startTime` = ? LIMIT 1");
            preparedStatement.setString(1, productionData.getProducerPodNumber());
            preparedStatement.setString(2, productionData.getDate().toString());
            preparedStatement.setString(3, productionData.getStartTime().toString());
            ResultSet resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) {
                PreparedStatement preparedStatementInsert = connection.prepareStatement("INSERT INTO `productionData` VALUES (?, ?, ?, ?)");
                preparedStatementInsert.setString(1, productionData.getProducerPodNumber());
                preparedStatementInsert.setString(2, productionData.getDate().toString());
                preparedStatementInsert.setString(3, productionData.getStartTime().toString());
                preparedStatementInsert.setDouble(4, productionData.getProfileValue());
                preparedStatementInsert.executeUpdate();
            } else {
                Double existingProfileValue = resultSet.getDouble("profileValue");
                PreparedStatement preparedStatementUpdate = connection.prepareStatement("UPDATE `productionData` SET `profileValue` = ? WHERE  `producer_pod-number` = ? AND `date` = ? AND `startTime` = ?");
                preparedStatementUpdate.setDouble(1, productionData.getProfileValue() + existingProfileValue);
                preparedStatementUpdate.setString(2, productionData.getProducerPodNumber());
                preparedStatementUpdate.setString(3, productionData.getDate().toString());
                preparedStatementUpdate.setString(4, productionData.getStartTime().toString());
                preparedStatementUpdate.executeUpdate();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static Double getProductionData(Producer producer, Date date, Time time) {
        Double returnValue = 0.0;
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT `profileValue` FROM `productionData` WHERE `producer_pod-number` = ? AND `date` = ? AND `startTime` = ? LIMIT 1");
            preparedStatement.setString(1, producer.getPodNumber());
            preparedStatement.setString(2, date.toString());
            preparedStatement.setString(3, time.toString());
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                returnValue = resultSet.getDouble("profileValue");
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return returnValue;
    }

    public static HashMap<Producer, Double> getProductionData(ArrayList<Producer> producers, Date date, Time time) {
        HashMap<Producer, Double> returnValue = new HashMap<Producer, Double>();
        for (Producer producer : producers) {
            try {
                PreparedStatement preparedStatement = connection.prepareStatement("SELECT `profileValue` FROM `productionData` WHERE `producer_pod-number` = ? AND `date` = ? AND `startTime` = ?");
                preparedStatement.setString(1, producer.getPodNumber());
                preparedStatement.setString(2, date.toString());
                preparedStatement.setString(3, time.toString());
                ResultSet resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    returnValue.put(producer, resultSet.getDouble("profileValue"));
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return returnValue;
    }

    public static void truncateProductionDataProducer(String producerPodNumber) {
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("DELETE FROM `productionData` WHERE `producer_pod-number` = ?");
            preparedStatement.setString(1, producerPodNumber);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void truncateProductionData() {
        try {
            statement.execute("DELETE FROM `productionData`");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void addProductionDataAfterSharing(ProductionDataAfterSharing productionDataAfterSharing) {
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO `productionDataAfterSharing` VALUES (?, ?, ?, ?, ?)");
            preparedStatement.setString(1, productionDataAfterSharing.getProducerPodNumber());
            preparedStatement.setString(2, productionDataAfterSharing.getDate().toString());
            preparedStatement.setString(3, productionDataAfterSharing.getStartTime().toString());
            preparedStatement.setDouble(4, productionDataAfterSharing.getEnergyCommunity());
            preparedStatement.setDouble(5, productionDataAfterSharing.getEnergyNetwork());
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void truncateProductionDataAfterSharing() {
        try {
            statement.execute("DELETE FROM `productionDataAfterSharing`;");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void deleteComputation() {
        DatabaseConnection.truncateConsumptionDataAfterSharing();
        DatabaseConnection.truncateProductionDataAfterSharing();
    }

    public static boolean podNumberExists(String podNumber) {
        boolean podNumberExists = false;
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT `pod-number` FROM `consumers` WHERE `pod-number` = ? UNION SELECT `pod-number` FROM `producers` WHERE `pod-number` = ? LIMIT 1");
            preparedStatement.setString(1, podNumber);
            preparedStatement.setString(2, podNumber);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                podNumberExists = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return podNumberExists;
    }

    public static Date getOldestStartDate() {
        Date oldestStartDate = new Date(System.currentTimeMillis());
        try {
            ResultSet resultSet = DatabaseConnection.query("SELECT MIN(`start-date`) AS `start-date` FROM (SELECT `start-date` AS `start-date` FROM `consumers` UNION SELECT `start-date` AS `start-date` FROM `producers`)");
            if (resultSet.next() && resultSet.getString("start-date") != null) {
                oldestStartDate = Date.valueOf(resultSet.getString("start-date"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return oldestStartDate;
    }

    public static Date getLatestEndDate() {
        Date latestEndDate = new Date(System.currentTimeMillis());
        try {
            ResultSet resultSet = DatabaseConnection.query("SELECT MAX(`end-date`) AS `end-date` FROM (SELECT `end-date` AS `end-date` FROM `consumers` UNION SELECT `end-date` AS `end-date` FROM `producers`)");
            if (resultSet.next() && resultSet.getString("end-date") != null) {
                latestEndDate = Date.valueOf(resultSet.getString("end-date"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return latestEndDate;
    }

    public static boolean consumerAndProducerDefined() {
        boolean returnValue = false;
        int nbConsumers = DatabaseConnection.getNumberOfConsumers();
        int nbProducers = DatabaseConnection.getNumberOfProducers();
        if (nbConsumers > 0 && nbProducers > 0) {
            returnValue = true;
        }
        return returnValue;
    }

    public static boolean computationCanBePerformed() {
        boolean returnValue = false;
        if (DatabaseConnection.consumerAndProducerDefined()) {
            int nbRecords = 0;
            try {
                ResultSet resultSet = DatabaseConnection.query("SELECT COUNT(*) FROM `consumptionDataAfterSharing`");
                while (resultSet.next()) {
                    nbRecords = resultSet.getInt(1);
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (nbRecords == 0) {
                returnValue = true;
            }
        }
        return returnValue;
    }

    public static boolean computationHasBeenPerformed() {
        boolean returnValue = false;
        int nbRecords = 0;
        try {
            ResultSet resultSet = DatabaseConnection.query("SELECT COUNT(*) FROM `consumptionDataAfterSharing`");
            while (resultSet.next()) {
                nbRecords = resultSet.getInt(1);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (nbRecords > 0) {
            returnValue = true;
        }
        return returnValue;
    }

    public static ArrayList<PDateTime> getPeriods() {
        ArrayList<PDateTime> periods = new ArrayList<PDateTime>();
        try {
            ResultSet resultSet = DatabaseConnection.query("SELECT DISTINCT `date`, `startTime` FROM `consumptionData`;");
            while (resultSet.next()) {
                periods.add(new PDateTime(resultSet.getString(1), resultSet.getString(2)));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return periods;
    }

    public static int getNumberPeriods(LocalDate startDate, LocalDate endDate) {
        int numberPeriods = 0;
        try {
            ResultSet resultSet = DatabaseConnection.query("SELECT COUNT(*) FROM (SELECT DISTINCT `date`, `startTime` FROM `consumptionData`);");
            while (resultSet.next()) {
                numberPeriods = resultSet.getInt(1);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return numberPeriods;
    }

    public static double[] getTotalEnergyDatas(String podNumber, LocalDate startDate, LocalDate endDate) {
        double[] results = null;
        boolean isConsumer = false;
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT `pod-number` FROM `consumers` WHERE `pod-number` = ? LIMIT 1");
            preparedStatement.setString(1, podNumber);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                isConsumer = true;
            }
            TreeMap energyDatas = new TreeMap();
            LocalDate date = startDate;
            while (date.isBefore(endDate.plusDays(1L))) {
                energyDatas.put(date.toString(), new TreeMap());
                LocalTime time = LocalTime.of(0, 0, 0, 0);
                int i = 96;
                while (i > 0) {
                    ((Map)energyDatas.get(date.toString())).put(time.format(dateTimeFormat), 0.0);
                    time = time.plusMinutes(15L);
                    --i;
                }
                date = date.plusDays(1L);
            }
            PreparedStatement preparedStatement2 = isConsumer ? connection.prepareStatement("SELECT `date`, `startTime`,`profileValue` FROM `consumptionData` WHERE `consumer_pod-number` = ? AND `date` >= ? AND `date` <= ? ORDER BY `date`, `startTime`") : connection.prepareStatement("SELECT `date`, `startTime`, `profileValue` FROM `productionData` WHERE `producer_pod-number` = ? AND `date` >= ? AND `date` <= ? ORDER BY `date`, `startTime`");
            preparedStatement2.setString(1, podNumber);
            preparedStatement2.setString(2, startDate.toString());
            preparedStatement2.setString(3, endDate.toString());
            ResultSet resultSet2 = preparedStatement2.executeQuery();
            while (resultSet2.next()) {
                ((Map)energyDatas.get(resultSet2.getString(1))).put(resultSet2.getString(2), resultSet2.getDouble(3));
            }
            int index = 0;
            results = new double[energyDatas.size() * 96];
            for (Map.Entry mapEntry : energyDatas.entrySet()) {
                Map valuesMap = (Map)mapEntry.getValue();
                for (Map.Entry valueEntry : valuesMap.entrySet()) {
                    results[index] = (Double)valueEntry.getValue() * 4.0;
                    ++index;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return results;
    }

    public static java.util.Date[] getDatesOfEnergyDatas(LocalDate startDate, LocalDate endDate) {
        java.util.Date[] results = null;
        try {
            TreeMap energyDatas = new TreeMap();
            LocalDate date = startDate;
            while (date.isBefore(endDate.plusDays(1L))) {
                energyDatas.put(date.toString(), new TreeMap());
                LocalTime time = LocalTime.of(0, 0, 0, 0);
                int i = 96;
                while (i > 0) {
                    ((Map)energyDatas.get(date.toString())).put(time.format(dateTimeFormat), 0.0);
                    time = time.plusMinutes(15L);
                    --i;
                }
                date = date.plusDays(1L);
            }
            int index = 0;
            results = new java.util.Date[energyDatas.size() * 96];
            for (Map.Entry mapEntry : energyDatas.entrySet()) {
                Map valuesMap = (Map)mapEntry.getValue();
                for (Map.Entry valueEntry : valuesMap.entrySet()) {
                    java.util.Date date2;
                    results[index] = date2 = DateUtils.parseDate((String)(String.valueOf((String)mapEntry.getKey()) + " " + (String)valueEntry.getKey()), (String[])new String[]{"yyyy-MM-dd HH:mm:ss", "dd/MM-yyyy"});
                    ++index;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return results;
    }

    public static double getTotalEnergy(String podNumber, LocalDate startDate, LocalDate endDate) {
        double totalEnergy = 0.0;
        try {
            boolean isConsumer = false;
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT `pod-number` FROM `consumers` WHERE `pod-number` = ? LIMIT 1");
            preparedStatement.setString(1, podNumber);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                isConsumer = true;
            }
            PreparedStatement preparedStatement2 = isConsumer ? connection.prepareStatement("SELECT SUM(`profileValue`) FROM `consumptionData` WHERE `consumer_pod-number` = ? AND `date` >= ? AND `date` <= ? ") : connection.prepareStatement("SELECT SUM(`profileValue`) FROM `productionData` WHERE `producer_pod-number` = ? AND `date` >= ? AND `date` <= ? ");
            preparedStatement2.setString(1, podNumber);
            preparedStatement2.setString(2, startDate.toString());
            preparedStatement2.setString(3, endDate.toString());
            ResultSet resultSet2 = preparedStatement2.executeQuery();
            resultSet2.next();
            totalEnergy = resultSet2.getDouble(1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return totalEnergy;
    }

    public static double[] getCommunityEnergyDatas(String podNumber, LocalDate startDate, LocalDate endDate) {
        double[] results = null;
        boolean isConsumer = false;
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT `pod-number` FROM `consumers` WHERE `pod-number` = ? LIMIT 1");
            preparedStatement.setString(1, podNumber);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                isConsumer = true;
            }
            TreeMap energyDatas = new TreeMap();
            LocalDate date = startDate;
            while (date.isBefore(endDate.plusDays(1L))) {
                energyDatas.put(date.toString(), new TreeMap());
                LocalTime time = LocalTime.of(0, 0, 0, 0);
                int i = 96;
                while (i > 0) {
                    ((Map)energyDatas.get(date.toString())).put(time.format(dateTimeFormat), 0.0);
                    time = time.plusMinutes(15L);
                    --i;
                }
                date = date.plusDays(1L);
            }
            PreparedStatement preparedStatement2 = isConsumer ? connection.prepareStatement("SELECT `date`, `startTime`,`energyCommunity` FROM `consumptionDataAfterSharing` WHERE `consumer_pod-number` = ? AND `date` >= ? AND `date` <= ? ORDER BY `date`, `startTime`") : connection.prepareStatement("SELECT `date`, `startTime`, `energyCommunity` FROM `productionDataAfterSharing` WHERE `producer_pod-number` = ? AND `date` >= ? AND `date` <= ? ORDER BY `date`, `startTime`");
            preparedStatement2.setString(1, podNumber);
            preparedStatement2.setString(2, startDate.toString());
            preparedStatement2.setString(3, endDate.toString());
            ResultSet resultSet2 = preparedStatement2.executeQuery();
            while (resultSet2.next()) {
                ((Map)energyDatas.get(resultSet2.getString(1))).put(resultSet2.getString(2), resultSet2.getDouble(3));
            }
            int index = 0;
            results = new double[energyDatas.size() * 96];
            for (Map.Entry mapEntry : energyDatas.entrySet()) {
                Map valuesMap = (Map)mapEntry.getValue();
                for (Map.Entry valueEntry : valuesMap.entrySet()) {
                    results[index] = (Double)valueEntry.getValue() * 4.0;
                    ++index;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return results;
    }

    public static double getCommunityEnergy(String podNumber, LocalDate startDate, LocalDate endDate) {
        double communityEnergy = 0.0;
        try {
            boolean isConsumer = false;
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT `pod-number` FROM `consumers` WHERE `pod-number` = ? LIMIT 1");
            preparedStatement.setString(1, podNumber);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                isConsumer = true;
            }
            PreparedStatement preparedStatement2 = isConsumer ? connection.prepareStatement("SELECT SUM(`energyCommunity`) FROM `consumptionDataAfterSharing` WHERE `consumer_pod-number` = ? AND `date` >= ? AND `date` <= ? ") : connection.prepareStatement("SELECT SUM(`energyCommunity`) FROM `productionDataAfterSharing` WHERE `producer_pod-number` = ? AND `date` >= ? AND `date` <= ? ");
            preparedStatement2.setString(1, podNumber);
            preparedStatement2.setString(2, startDate.toString());
            preparedStatement2.setString(3, endDate.toString());
            ResultSet resultSet2 = preparedStatement2.executeQuery();
            resultSet2.next();
            communityEnergy = resultSet2.getDouble(1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return communityEnergy;
    }

    public static double[] getNetworkEnergyDatas(String podNumber, LocalDate startDate, LocalDate endDate) {
        double[] results = null;
        boolean isConsumer = false;
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT `pod-number` FROM `consumers` WHERE `pod-number` = ? LIMIT 1");
            preparedStatement.setString(1, podNumber);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                isConsumer = true;
            }
            TreeMap energyDatas = new TreeMap();
            LocalDate date = startDate;
            while (date.isBefore(endDate.plusDays(1L))) {
                energyDatas.put(date.toString(), new TreeMap());
                LocalTime time = LocalTime.of(0, 0, 0, 0);
                int i = 96;
                while (i > 0) {
                    ((Map)energyDatas.get(date.toString())).put(time.format(dateTimeFormat), 0.0);
                    time = time.plusMinutes(15L);
                    --i;
                }
                date = date.plusDays(1L);
            }
            PreparedStatement preparedStatement2 = isConsumer ? connection.prepareStatement("SELECT `date`, `startTime`, `energyNetwork` FROM `consumptionDataAfterSharing` WHERE `consumer_pod-number` = ? AND `date` >= ? AND `date` <= ? ORDER BY `date`, `startTime`") : connection.prepareStatement("SELECT `date`, `startTime`, `energyNetwork` FROM `productionDataAfterSharing` WHERE `producer_pod-number` = ? AND `date` >= ? AND `date` <= ? ORDER BY `date`, `startTime`");
            preparedStatement2.setString(1, podNumber);
            preparedStatement2.setString(2, startDate.toString());
            preparedStatement2.setString(3, endDate.toString());
            ResultSet resultSet2 = preparedStatement2.executeQuery();
            while (resultSet2.next()) {
                ((Map)energyDatas.get(resultSet2.getString(1))).put(resultSet2.getString(2), resultSet2.getDouble(3));
            }
            int index = 0;
            results = new double[energyDatas.size() * 96];
            for (Map.Entry mapEntry : energyDatas.entrySet()) {
                Map valuesMap = (Map)mapEntry.getValue();
                for (Map.Entry valueEntry : valuesMap.entrySet()) {
                    results[index] = (Double)valueEntry.getValue() * 4.0;
                    ++index;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return results;
    }

    public static double getNetworkEnergy(String podNumber, LocalDate startDate, LocalDate endDate) {
        double networkEnergy = 0.0;
        try {
            boolean isConsumer = false;
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT `pod-number` FROM `consumers` WHERE `pod-number` = ? LIMIT 1");
            preparedStatement.setString(1, podNumber);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                isConsumer = true;
            }
            PreparedStatement preparedStatement2 = isConsumer ? connection.prepareStatement("SELECT SUM(`energyNetwork`) FROM `consumptionDataAfterSharing` WHERE `consumer_pod-number` = ? AND `date` >= ? AND `date` <= ? ") : connection.prepareStatement("SELECT SUM(`energyNetwork`) FROM `productionDataAfterSharing` WHERE `producer_pod-number` = ? AND `date` >= ? AND `date` <= ? ");
            preparedStatement2.setString(1, podNumber);
            preparedStatement2.setString(2, startDate.toString());
            preparedStatement2.setString(3, endDate.toString());
            ResultSet resultSet2 = preparedStatement2.executeQuery();
            resultSet2.next();
            networkEnergy = resultSet2.getDouble(1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return networkEnergy;
    }

    public static int getNumberOfConsumers() {
        int numberofConsumers = 0;
        try {
            ResultSet resultSet = DatabaseConnection.query("SELECT COUNT(`pod-number`) FROM `consumers`");
            resultSet.next();
            numberofConsumers = resultSet.getInt(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return numberofConsumers;
    }

    public static int getNumberOfProducers() {
        int numberofProducers = 0;
        try {
            ResultSet resultSet = DatabaseConnection.query("SELECT COUNT(`pod-number`) FROM `producers`");
            resultSet.next();
            numberofProducers = resultSet.getInt(1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return numberofProducers;
    }

    public static int getMaxProfileValue(Map<String, Boolean> showLinesTotalEnergy, Map<String, Boolean> showLinesCommunityEnergy, Map<String, Boolean> showLinesNetworkEnergy, LocalDate startDate, LocalDate endDate) {
        String totalSelected = "";
        for (Map.Entry<String, Boolean> entry : showLinesTotalEnergy.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            totalSelected = String.valueOf(totalSelected) + "\"" + entry.getKey() + "\", ";
        }
        if (!totalSelected.equals("")) {
            totalSelected = totalSelected.substring(0, totalSelected.length() - 2);
        }
        String communitySelected = "";
        for (Map.Entry<String, Boolean> entry : showLinesCommunityEnergy.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            communitySelected = String.valueOf(communitySelected) + "\"" + entry.getKey() + "\", ";
        }
        if (!communitySelected.equals("")) {
            communitySelected = communitySelected.substring(0, communitySelected.length() - 2);
        }
        String networkSelected = "";
        for (Map.Entry<String, Boolean> entry : showLinesNetworkEnergy.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            networkSelected = String.valueOf(networkSelected) + "\"" + entry.getKey() + "\", ";
        }
        if (!networkSelected.equals("")) {
            networkSelected = networkSelected.substring(0, networkSelected.length() - 2);
        }
        int result = 0;
        try {
            ResultSet resultSet = DatabaseConnection.query("SELECT MAX(`value`) FROM (SELECT `profileValue` AS `value` FROM `consumptionData` WHERE `consumer_pod-number` IN (" + totalSelected + ") " + "AND `date` >= \"" + startDate.toString() + "\" " + "AND `date` <= \"" + endDate.toString() + "\" " + "UNION ALL " + "SELECT `profileValue` AS `value` FROM `productionData` " + "WHERE `producer_pod-number` IN (" + totalSelected + ") " + "AND `date` >= \"" + startDate.toString() + "\" " + "AND `date` <= \"" + endDate.toString() + "\" " + "UNION ALL " + "SELECT `energyCommunity` AS `value` FROM `consumptionDataAfterSharing` " + "WHERE `consumer_pod-number` IN (" + communitySelected + ") " + "AND `date` >= \"" + startDate.toString() + "\" " + "AND `date` <= \"" + endDate.toString() + "\" " + "UNION ALL " + "SELECT `energyCommunity` AS `value` FROM `productionDataAfterSharing` " + "WHERE `producer_pod-number` IN (" + communitySelected + ") " + "AND `date` >= \"" + startDate.toString() + "\" " + "AND `date` <= \"" + endDate.toString() + "\" " + "UNION ALL " + "SELECT `energyNetwork` AS `value` FROM `consumptionDataAfterSharing` " + "WHERE `consumer_pod-number` IN (" + networkSelected + ") " + "AND `date` >= \"" + startDate.toString() + "\" " + "AND `date` <= \"" + endDate.toString() + "\" " + "UNION ALL " + "SELECT `energyNetwork` AS `value` FROM `productionDataAfterSharing` " + "WHERE `producer_pod-number` IN (" + networkSelected + ") " + "AND `date` >= \"" + startDate.toString() + "\" " + "AND `date` <= \"" + endDate.toString() + "\")");
            resultSet.next();
            double resultDouble = resultSet.getDouble(1);
            if (resultDouble == 0.0) {
                result = 5;
            } else {
                result = (int)resultDouble;
                ++result;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static Color getFirstUnusedConsumerColor() {
        Color color = new Color((Device)Display.getDefault(), 0, 0, 0);
        try {
            ResultSet resultSet = DatabaseConnection.query("SELECT `rgb` FROM `colorsConsumers` WHERE `used` = 0 ORDER BY `id` LIMIT 1");
            resultSet.next();
            String rgb = resultSet.getString(1);
            String[] colors = rgb.split(",");
            color = new Color((Device)Display.getDefault(), Integer.parseInt(colors[0]), Integer.parseInt(colors[1]), Integer.parseInt(colors[2]));
            PreparedStatement preparedStatement = connection.prepareStatement("UPDATE `colorsConsumers` SET `used` = 1 WHERE `rgb` = ?");
            preparedStatement.setString(1, rgb);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return color;
    }

    public static Color getFirstUnusedProducerColor() {
        Color color = new Color((Device)Display.getDefault(), 0, 0, 0);
        try {
            ResultSet resultSet = DatabaseConnection.query("SELECT `rgb` FROM `colorsProducers` WHERE `used` = 0 ORDER BY `id` LIMIT 1");
            resultSet.next();
            String rgb = resultSet.getString(1);
            String[] colors = rgb.split(",");
            color = new Color((Device)Display.getDefault(), Integer.parseInt(colors[0]), Integer.parseInt(colors[1]), Integer.parseInt(colors[2]));
            PreparedStatement preparedStatement = connection.prepareStatement("UPDATE `colorsProducers` SET `used` = 1 WHERE `rgb` = ?");
            preparedStatement.setString(1, rgb);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return color;
    }

    public static void resetUsedColors() {
        try {
            statement.execute("UPDATE `colorsConsumers` SET `used` = 0");
            statement.execute("UPDATE `colorsProducers` SET `used` = 0");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void createDatabase() {
        try {
            statement.execute("CREATE TABLE IF NOT EXISTS `colorsConsumers` (`id` INTEGER, `rgb` TEXT NOT NULL UNIQUE, `used` INTEGER DEFAULT 0, PRIMARY KEY(`id`))");
            statement.execute("CREATE TABLE IF NOT EXISTS `colorsProducers` (`id` INTEGER, `rgb` TEXT NOT NULL UNIQUE, `used` INTEGER DEFAULT 0, PRIMARY KEY(`id`))");
            statement.execute("CREATE TABLE IF NOT EXISTS `consumers` (`pod-number` TEXT NOT NULL, `name` TEXT NOT NULL UNIQUE, `start-date` TEXT, `start-time` TEXT, `end-date` TEXT, `end-time` TEXT, `priority` INTEGER DEFAULT 0, `percentage` INTEGER DEFAULT 0, `prorata` INTEGER DEFAULT 1, `rgb` TEXT DEFAULT '0,0,0', PRIMARY KEY(`pod-number`))");
            statement.execute("CREATE TABLE IF NOT EXISTS `consumptionData` (`consumer_pod-number` TEXT NOT NULL,`date` TEXT NOT NULL, `startTime` TEXT NOT NULL, `profileValue` REAL, PRIMARY KEY(`consumer_pod-number`,`date`,`startTime`), FOREIGN KEY(`consumer_pod-number`) REFERENCES `consumers`(`pod-number`))");
            statement.execute("CREATE TABLE IF NOT EXISTS `consumptionDataAfterSharing` (`consumer_pod-number` TEXT NOT NULL, `date` TEXT NOT NULL, `startTime` TEXT NOT NULL, `energyCommunity` REAL, `energyNetwork` REAL, PRIMARY KEY(`consumer_pod-number`,`date`,`startTime`), FOREIGN KEY(`consumer_pod-number`) REFERENCES `consumers`(`pod-number`))");
            statement.execute("CREATE TABLE IF NOT EXISTS `producers` (`pod-number` TEXT NOT NULL, `name` TEXT NOT NULL UNIQUE, `start-date` TEXT, `start-time` TEXT, `end-date` TEXT, `end-time` TEXT, `priority` INTEGER DEFAULT 0, \t`rgb` TEXT DEFAULT '0,0,0', PRIMARY KEY(`pod-number`))");
            statement.execute("CREATE TABLE IF NOT EXISTS `productionData` (`producer_pod-number` TEXT NOT NULL, `date` TEXT NOT NULL, `startTime` TEXT NOT NULL, `profileValue` REAL, PRIMARY KEY(`producer_pod-number`,`date`,`startTime`), FOREIGN KEY(`producer_pod-number`) REFERENCES `producers`(`pod-number`))");
            statement.execute("CREATE TABLE IF NOT EXISTS `productionDataAfterSharing` (`producer_pod-number` TEXT NOT NULL, `date` TEXT NOT NULL, `startTime` TEXT NOT NULL, `energyCommunity` REAL, `energyNetwork` REAL, PRIMARY KEY(`producer_pod-number`,`date`,`startTime`), FOREIGN KEY(`producer_pod-number`) REFERENCES `producers`(`pod-number`))");
            statement.execute("INSERT INTO `colorsConsumers` VALUES (1,'124,252,0',0)");
            statement.execute("INSERT INTO `colorsConsumers` VALUES (2,'47,79,79',0)");
            statement.execute("INSERT INTO `colorsConsumers` VALUES (3,'30,144,255',0)");
            statement.execute("INSERT INTO `colorsConsumers` VALUES (4,'0,128,0',0)");
            statement.execute("INSERT INTO `colorsConsumers` VALUES (5,'100,149,237',0)");
            statement.execute("INSERT INTO `colorsConsumers` VALUES (6,'50,205,50',0)");
            statement.execute("INSERT INTO `colorsConsumers` VALUES (7,'176,224,230',0)");
            statement.execute("INSERT INTO `colorsConsumers` VALUES (8,'143,188,143',0)");
            statement.execute("INSERT INTO `colorsConsumers` VALUES (9,'25,25,112',0)");
            statement.execute("INSERT INTO `colorsConsumers` VALUES (10,'127,255,212',0)");
            statement.execute("INSERT INTO `colorsConsumers` VALUES (11,'46,139,87',0)");
            statement.execute("INSERT INTO `colorsConsumers` VALUES (12,'0,206,209',0)");
            statement.execute("INSERT INTO `colorsConsumers` VALUES (13,'32,178,170',0)");
            statement.execute("INSERT INTO `colorsConsumers` VALUES (14,'0,255,255',0)");
            statement.execute("INSERT INTO `colorsConsumers` VALUES (15,'173,255,47',0)");
            statement.execute("INSERT INTO `colorsProducers` VALUES (1,'128,0,0',0)");
            statement.execute("INSERT INTO `colorsProducers` VALUES (2,'255,255,0',0)");
            statement.execute("INSERT INTO `colorsProducers` VALUES (3,'220,20,60',0)");
            statement.execute("INSERT INTO `colorsProducers` VALUES (4,'189,183,107',0)");
            statement.execute("INSERT INTO `colorsProducers` VALUES (5,'255,0,0',0)");
            statement.execute("INSERT INTO `colorsProducers` VALUES (6,'205,92,92',0)");
            statement.execute("INSERT INTO `colorsProducers` VALUES (7,'184,134,11',0)");
            statement.execute("INSERT INTO `colorsProducers` VALUES (8,'250,128,114',0)");
            statement.execute("INSERT INTO `colorsProducers` VALUES (9,'255,165,0',0)");
            statement.execute("INSERT INTO `colorsProducers` VALUES (10,'255,69,0',0)");
        }
        catch (SQLException e) {
            System.out.println("ERREUR SQL: " + e);
        }
    }
}

