/*
 * Decompiled with CFR 0.152.
 */
package computation;

import db.DatabaseConnection;
import java.sql.Date;
import java.sql.Time;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.swt.widgets.ProgressBar;
import persistance.Consumer;
import persistance.ConsumptionDataAfterSharing;
import persistance.PDateTime;
import persistance.Producer;
import persistance.ProductionDataAfterSharing;
import ui.EnergeticCommunitiesSimulator;

public final class ComputeSharing {
    protected static ArrayList<Consumer> consumers;
    private static Iterator<Consumer> itConsumers;
    protected static ArrayList<Producer> producers;
    private static Iterator<Producer> itProducers;
    private static HashMap<Consumer, Double> consumptionData;
    private static HashMap<Producer, Double> productionData;

    private ComputeSharing() {
        throw new UnsupportedOperationException();
    }

    public static void compute(LocalDate startDate, LocalDate endDate, ProgressBar progressBar) {
        consumers = DatabaseConnection.getAllConsumers();
        producers = DatabaseConnection.getAllProducers();
        HashMap<Integer, ArrayList<Producer>> priorityProducers = DatabaseConnection.getPriorityProducersByPriority();
        HashMap<Integer, ArrayList<Consumer>> priorityConsumers = DatabaseConnection.getPriorityConsumersByPriority();
        ArrayList<Producer> nonPriorityProducers = DatabaseConnection.getNonPriorityProducers();
        ArrayList<Consumer> percentageConsumers = DatabaseConnection.getPercentageConsumers();
        boolean prorataEnabled = true;
        for (Consumer consumer : consumers) {
            if (consumer.getProrata() != 0) continue;
            prorataEnabled = false;
        }
        int currentRecord = 1;
        int nbRecords = DatabaseConnection.getNumberPeriods(startDate, endDate);
        progressBar.setVisible(true);
        DatabaseConnection.startTransaction();
        for (PDateTime period : DatabaseConnection.getPeriods()) {
            double newConsumptionFromCommunity;
            double newConsumptionFromNetwork;
            double energyReceived;
            double newConsumptionFromCommunity2;
            double energyNeeded;
            double newProductionToCommunity;
            double energyTransfered;
            double newProductionToCommunity2;
            double remainingEnergyToNetwork;
            double energyTransfered2;
            double percentage;
            double energyAvailable;
            double d;
            Date currentDate = Date.valueOf(period.getDate());
            Time currentTime = Time.valueOf(period.getTime());
            consumptionData = DatabaseConnection.getConsumptionData(consumers, currentDate, currentTime);
            productionData = DatabaseConnection.getProductionData(producers, currentDate, currentTime);
            HashMap<String, Double> consumptionFromNetwork = new HashMap<String, Double>();
            HashMap<String, Double> consumptionFromCommunity = new HashMap<String, Double>();
            HashMap<String, Double> productionToNetwork = new HashMap<String, Double>();
            HashMap<String, Double> productionToCommunity = new HashMap<String, Double>();
            if (prorataEnabled) {
                double d2;
                double econs = 0.0;
                for (Map.Entry<Consumer, Double> mapEntry : consumptionData.entrySet()) {
                    econs += mapEntry.getValue().doubleValue();
                }
                double eprod = 0.0;
                for (Map.Entry<Producer, Double> mapEntry : productionData.entrySet()) {
                    eprod += mapEntry.getValue().doubleValue();
                }
                if (eprod >= econs) {
                    for (Consumer consumer : consumers) {
                        consumptionFromNetwork.put(consumer.getPodNumber(), 0.0);
                        consumptionFromCommunity.put(consumer.getPodNumber(), DatabaseConnection.getConsumptionData(consumer, currentDate, currentTime));
                    }
                    for (Producer producer : producers) {
                        productionToNetwork.put(producer.getPodNumber(), DatabaseConnection.getProductionData(producer, currentDate, currentTime));
                        productionToCommunity.put(producer.getPodNumber(), 0.0);
                    }
                    for (Map.Entry<Integer, ArrayList<Producer>> entry : priorityProducers.entrySet()) {
                        double totalEnergyAvailable = 0.0;
                        for (Producer producer : entry.getValue()) {
                            if (!((Double)productionToNetwork.get(producer.getPodNumber()) > 0.0)) continue;
                            totalEnergyAvailable += ((Double)productionToNetwork.get(producer.getPodNumber())).doubleValue();
                        }
                        d = 0.0;
                        if (totalEnergyAvailable <= econs) {
                            for (Producer producer : entry.getValue()) {
                                energyAvailable = (Double)productionToNetwork.get(producer.getPodNumber());
                                productionToNetwork.put(producer.getPodNumber(), 0.0);
                                productionToCommunity.put(producer.getPodNumber(), energyAvailable);
                                d += energyAvailable;
                            }
                        } else {
                            for (Producer producer : entry.getValue()) {
                                energyAvailable = (Double)productionToNetwork.get(producer.getPodNumber());
                                if (!(totalEnergyAvailable > 0.0)) continue;
                                percentage = energyAvailable / totalEnergyAvailable;
                                energyTransfered2 = econs * percentage;
                                remainingEnergyToNetwork = (Double)productionToNetwork.get(producer.getPodNumber()) - energyTransfered2;
                                newProductionToCommunity2 = (Double)productionToCommunity.get(producer.getPodNumber()) + energyTransfered2;
                                productionToCommunity.put(producer.getPodNumber(), newProductionToCommunity2);
                                productionToNetwork.put(producer.getPodNumber(), remainingEnergyToNetwork);
                                d += newProductionToCommunity2;
                            }
                        }
                        econs -= d;
                    }
                    d2 = 0.0;
                    if (econs > 0.0) {
                        for (Producer producer : producers) {
                            if (!((Double)productionToNetwork.get(producer.getPodNumber()) > 0.0)) continue;
                            d2 += ((Double)productionToNetwork.get(producer.getPodNumber())).doubleValue();
                        }
                        for (Producer producer : producers) {
                            if (!((Double)productionToNetwork.get(producer.getPodNumber()) > 0.0)) continue;
                            d = (Double)productionToNetwork.get(producer.getPodNumber());
                            if (!(d2 > 0.0)) continue;
                            double d3 = d / d2;
                            energyTransfered = econs * d3;
                            double remainingEnergyToNetwork2 = (Double)productionToNetwork.get(producer.getPodNumber()) - energyTransfered;
                            newProductionToCommunity = (Double)productionToCommunity.get(producer.getPodNumber()) + energyTransfered;
                            productionToCommunity.put(producer.getPodNumber(), newProductionToCommunity);
                            productionToNetwork.put(producer.getPodNumber(), remainingEnergyToNetwork2);
                        }
                    }
                } else {
                    for (Producer producer : producers) {
                        productionToNetwork.put(producer.getPodNumber(), 0.0);
                        productionToCommunity.put(producer.getPodNumber(), DatabaseConnection.getProductionData(producer, currentDate, currentTime));
                    }
                    for (Consumer consumer : consumers) {
                        consumptionFromNetwork.put(consumer.getPodNumber(), DatabaseConnection.getConsumptionData(consumer, currentDate, currentTime));
                        consumptionFromCommunity.put(consumer.getPodNumber(), 0.0);
                    }
                    for (Map.Entry<Integer, ArrayList<Consumer>> entry : priorityConsumers.entrySet()) {
                        double totalEnergyNeeded2 = 0.0;
                        for (Consumer consumer : entry.getValue()) {
                            if (!((Double)consumptionFromNetwork.get(consumer.getPodNumber()) > 0.0)) continue;
                            totalEnergyNeeded2 += ((Double)consumptionFromNetwork.get(consumer.getPodNumber())).doubleValue();
                        }
                        d = 0.0;
                        if (totalEnergyNeeded2 <= eprod) {
                            for (Consumer consumer : entry.getValue()) {
                                energyNeeded = (Double)consumptionFromNetwork.get(consumer.getPodNumber());
                                consumptionFromNetwork.put(consumer.getPodNumber(), 0.0);
                                newConsumptionFromCommunity2 = (Double)consumptionFromCommunity.get(consumer.getPodNumber()) + energyNeeded;
                                consumptionFromCommunity.put(consumer.getPodNumber(), newConsumptionFromCommunity2);
                                d += energyNeeded;
                            }
                        } else {
                            for (Consumer consumer : entry.getValue()) {
                                energyNeeded = (Double)consumptionFromNetwork.get(consumer.getPodNumber());
                                if (!(totalEnergyNeeded2 > 0.0)) continue;
                                percentage = energyNeeded / totalEnergyNeeded2;
                                energyReceived = eprod * percentage;
                                newConsumptionFromNetwork = (Double)consumptionFromNetwork.get(consumer.getPodNumber()) - energyReceived;
                                consumptionFromNetwork.put(consumer.getPodNumber(), newConsumptionFromNetwork);
                                newConsumptionFromCommunity = (Double)consumptionFromCommunity.get(consumer.getPodNumber()) + energyReceived;
                                consumptionFromCommunity.put(consumer.getPodNumber(), newConsumptionFromCommunity);
                                d += energyReceived;
                            }
                        }
                        eprod -= d;
                    }
                    d2 = 0.0;
                    if (eprod > 0.0) {
                        for (Consumer consumer : percentageConsumers) {
                            double energyAvailable2;
                            double energyNeeded2 = (Double)consumptionFromNetwork.get(consumer.getPodNumber());
                            if (energyNeeded2 <= (energyAvailable2 = eprod * (double)consumer.getPercentage() / 100.0)) {
                                double newConsumptionFromCommunity22 = (Double)consumptionFromCommunity.get(consumer.getPodNumber()) + energyNeeded2;
                                consumptionFromCommunity.put(consumer.getPodNumber(), newConsumptionFromCommunity22);
                                consumptionFromNetwork.put(consumer.getPodNumber(), 0.0);
                                d2 += energyNeeded2;
                                continue;
                            }
                            newConsumptionFromCommunity2 = (Double)consumptionFromCommunity.get(consumer.getPodNumber()) + energyAvailable2;
                            consumptionFromCommunity.put(consumer.getPodNumber(), newConsumptionFromCommunity2);
                            double newConsumptionFromNetwork2 = energyNeeded2 - energyAvailable2;
                            consumptionFromNetwork.put(consumer.getPodNumber(), newConsumptionFromNetwork2);
                            d2 += energyAvailable2;
                        }
                    }
                    Double remainingEnergyToShare = eprod -= d2;
                    d = 0.0;
                    for (Consumer consumer : consumers) {
                        if (!((Double)consumptionFromNetwork.get(consumer.getPodNumber()) > 0.0)) continue;
                        d += ((Double)consumptionFromNetwork.get(consumer.getPodNumber())).doubleValue();
                    }
                    itConsumers = consumers.iterator();
                    while (itConsumers.hasNext() && remainingEnergyToShare > 0.0) {
                        Consumer consumer = itConsumers.next();
                        if (!((Double)consumptionFromNetwork.get(consumer.getPodNumber()) > 0.0)) continue;
                        energyNeeded = (Double)consumptionFromNetwork.get(consumer.getPodNumber());
                        if (!(d > 0.0)) continue;
                        percentage = energyNeeded / d;
                        energyReceived = eprod * percentage;
                        remainingEnergyToShare = remainingEnergyToShare - energyReceived;
                        double newConsumptionFromCommunity3 = (Double)consumptionFromCommunity.get(consumer.getPodNumber()) + energyReceived;
                        consumptionFromCommunity.put(consumer.getPodNumber(), newConsumptionFromCommunity3);
                        double newConsumptionFromNetwork3 = (Double)consumptionFromNetwork.get(consumer.getPodNumber()) - energyReceived;
                        consumptionFromNetwork.put(consumer.getPodNumber(), newConsumptionFromNetwork3);
                    }
                }
            } else {
                double newConsumptionFromCommunity3;
                double percentage2;
                double newConsumptionFromCommunity4;
                for (Producer producer : producers) {
                    productionToNetwork.put(producer.getPodNumber(), DatabaseConnection.getProductionData(producer, currentDate, currentTime));
                    productionToCommunity.put(producer.getPodNumber(), 0.0);
                }
                for (Consumer consumer : consumers) {
                    consumptionFromNetwork.put(consumer.getPodNumber(), DatabaseConnection.getConsumptionData(consumer, currentDate, currentTime));
                    consumptionFromCommunity.put(consumer.getPodNumber(), 0.0);
                }
                for (Map.Entry<Integer, ArrayList<Producer>> mapEntryProducers : priorityProducers.entrySet()) {
                    double totalEnergyAvailable = 0.0;
                    for (Producer priorityProducer : mapEntryProducers.getValue()) {
                        if (!((Double)productionToNetwork.get(priorityProducer.getPodNumber()) > 0.0)) continue;
                        totalEnergyAvailable += ((Double)productionToNetwork.get(priorityProducer.getPodNumber())).doubleValue();
                    }
                    double totalEnergyReceivedPriority = 0.0;
                    for (Map.Entry<Integer, ArrayList<Consumer>> mapEntryConsumers : priorityConsumers.entrySet()) {
                        d = 0.0;
                        for (Consumer consumer : mapEntryConsumers.getValue()) {
                            d += ((Double)consumptionFromNetwork.get(consumer.getPodNumber())).doubleValue();
                        }
                        if (d <= totalEnergyAvailable) {
                            for (Consumer consumer : mapEntryConsumers.getValue()) {
                                energyNeeded = (Double)consumptionFromNetwork.get(consumer.getPodNumber());
                                consumptionFromNetwork.put(consumer.getPodNumber(), 0.0);
                                newConsumptionFromCommunity2 = (Double)consumptionFromCommunity.get(consumer.getPodNumber()) + energyNeeded;
                                consumptionFromCommunity.put(consumer.getPodNumber(), newConsumptionFromCommunity2);
                                totalEnergyReceivedPriority += energyNeeded;
                            }
                            continue;
                        }
                        for (Consumer consumer : mapEntryConsumers.getValue()) {
                            energyNeeded = (Double)consumptionFromNetwork.get(consumer.getPodNumber());
                            if (!(d > 0.0)) continue;
                            percentage = energyNeeded / d;
                            energyReceived = totalEnergyAvailable * percentage;
                            newConsumptionFromNetwork = (Double)consumptionFromNetwork.get(consumer.getPodNumber()) - energyReceived;
                            consumptionFromNetwork.put(consumer.getPodNumber(), newConsumptionFromNetwork);
                            newConsumptionFromCommunity = (Double)consumptionFromCommunity.get(consumer.getPodNumber()) + energyReceived;
                            consumptionFromCommunity.put(consumer.getPodNumber(), newConsumptionFromCommunity);
                            totalEnergyReceivedPriority += energyReceived;
                        }
                    }
                    for (Producer priorityProducer : mapEntryProducers.getValue()) {
                        d = (Double)productionToNetwork.get(priorityProducer.getPodNumber());
                        if (!(totalEnergyAvailable > 0.0)) continue;
                        double d4 = d / totalEnergyAvailable;
                        energyTransfered = totalEnergyReceivedPriority * d4;
                        double remainingEnergyToNetwork4 = (Double)productionToNetwork.get(priorityProducer.getPodNumber()) - energyTransfered;
                        newProductionToCommunity = (Double)productionToCommunity.get(priorityProducer.getPodNumber()) + energyTransfered;
                        productionToCommunity.put(priorityProducer.getPodNumber(), newProductionToCommunity);
                        productionToNetwork.put(priorityProducer.getPodNumber(), remainingEnergyToNetwork4);
                    }
                    totalEnergyAvailable -= totalEnergyReceivedPriority;
                    double totalEnergyReceivedPercentage = 0.0;
                    for (Consumer consumer : percentageConsumers) {
                        double energyAvailable2;
                        energyNeeded = (Double)consumptionFromNetwork.get(consumer.getPodNumber());
                        if (energyNeeded <= (energyAvailable2 = totalEnergyAvailable * (double)consumer.getPercentage() / 100.0)) {
                            newConsumptionFromCommunity4 = (Double)consumptionFromCommunity.get(consumer.getPodNumber()) + energyNeeded;
                            consumptionFromCommunity.put(consumer.getPodNumber(), newConsumptionFromCommunity4);
                            consumptionFromNetwork.put(consumer.getPodNumber(), 0.0);
                            totalEnergyReceivedPercentage += energyNeeded;
                            continue;
                        }
                        newConsumptionFromCommunity4 = (Double)consumptionFromCommunity.get(consumer.getPodNumber()) + energyAvailable2;
                        consumptionFromCommunity.put(consumer.getPodNumber(), newConsumptionFromCommunity4);
                        newConsumptionFromNetwork = energyNeeded - energyAvailable2;
                        consumptionFromNetwork.put(consumer.getPodNumber(), newConsumptionFromNetwork);
                        totalEnergyReceivedPercentage += energyAvailable2;
                    }
                    for (Producer producer : mapEntryProducers.getValue()) {
                        energyAvailable = (Double)productionToNetwork.get(producer.getPodNumber());
                        if (!(totalEnergyAvailable > 0.0)) continue;
                        percentage = energyAvailable / totalEnergyAvailable;
                        energyTransfered2 = totalEnergyReceivedPercentage * percentage;
                        remainingEnergyToNetwork = (Double)productionToNetwork.get(producer.getPodNumber()) - energyTransfered2;
                        newProductionToCommunity2 = (Double)productionToCommunity.get(producer.getPodNumber()) + energyTransfered2;
                        productionToCommunity.put(producer.getPodNumber(), newProductionToCommunity2);
                        productionToNetwork.put(producer.getPodNumber(), remainingEnergyToNetwork);
                    }
                    totalEnergyAvailable -= totalEnergyReceivedPercentage;
                    double d5 = 0.0;
                    if (!(totalEnergyAvailable > 0.0)) continue;
                    double totalEnergyNeeded = 0.0;
                    for (Consumer consumer : consumers) {
                        if (!((Double)consumptionFromNetwork.get(consumer.getPodNumber()) > 0.0) || consumer.getProrata() != 1) continue;
                        totalEnergyNeeded += ((Double)consumptionFromNetwork.get(consumer.getPodNumber())).doubleValue();
                    }
                    for (Consumer consumer : consumers) {
                        if (!((Double)consumptionFromNetwork.get(consumer.getPodNumber()) > 0.0) || consumer.getProrata() != 1) continue;
                        double energyNeeded2 = (Double)consumptionFromNetwork.get(consumer.getPodNumber());
                        if (!(totalEnergyNeeded > 0.0)) continue;
                        percentage2 = energyNeeded2 / totalEnergyNeeded;
                        double energyReceived2 = totalEnergyAvailable * percentage2;
                        if (energyReceived2 > energyNeeded2) {
                            newConsumptionFromCommunity3 = (Double)consumptionFromCommunity.get(consumer.getPodNumber()) + energyNeeded2;
                            consumptionFromCommunity.put(consumer.getPodNumber(), newConsumptionFromCommunity3);
                            consumptionFromNetwork.put(consumer.getPodNumber(), 0.0);
                            d5 += energyNeeded2;
                            continue;
                        }
                        newConsumptionFromCommunity3 = (Double)consumptionFromCommunity.get(consumer.getPodNumber()) + energyReceived2;
                        consumptionFromCommunity.put(consumer.getPodNumber(), newConsumptionFromCommunity3);
                        double newConsumptionFromNetwork2 = (Double)consumptionFromNetwork.get(consumer.getPodNumber()) - energyReceived2;
                        consumptionFromNetwork.put(consumer.getPodNumber(), newConsumptionFromNetwork2);
                        d5 += energyReceived2;
                    }
                    for (Producer priorityProducer : mapEntryProducers.getValue()) {
                        double energyAvailable3 = (Double)productionToNetwork.get(priorityProducer.getPodNumber());
                        if (!(totalEnergyAvailable > 0.0)) continue;
                        percentage2 = energyAvailable3 / totalEnergyAvailable;
                        double energyTransfered3 = d5 * percentage2;
                        double remainingEnergyToNetwork2 = (Double)productionToNetwork.get(priorityProducer.getPodNumber()) - energyTransfered3;
                        double newProductionToCommunity3 = (Double)productionToCommunity.get(priorityProducer.getPodNumber()) + energyTransfered3;
                        productionToCommunity.put(priorityProducer.getPodNumber(), newProductionToCommunity3);
                        productionToNetwork.put(priorityProducer.getPodNumber(), remainingEnergyToNetwork2);
                    }
                }
                double totalEnergyAvailable = 0.0;
                for (Producer nonPriorityProducer : nonPriorityProducers) {
                    totalEnergyAvailable += ((Double)productionToNetwork.get(nonPriorityProducer.getPodNumber())).doubleValue();
                }
                if (totalEnergyAvailable > 0.0) {
                    double totalEnergyReceivedPriority = 0.0;
                    for (Map.Entry<Integer, ArrayList<Consumer>> mapEntryConsumers : priorityConsumers.entrySet()) {
                        d = 0.0;
                        for (Consumer consumer : mapEntryConsumers.getValue()) {
                            d += ((Double)consumptionFromNetwork.get(consumer.getPodNumber())).doubleValue();
                        }
                        if (d <= totalEnergyAvailable) {
                            for (Consumer consumer : mapEntryConsumers.getValue()) {
                                energyNeeded = (Double)consumptionFromNetwork.get(consumer.getPodNumber());
                                consumptionFromNetwork.put(consumer.getPodNumber(), 0.0);
                                newConsumptionFromCommunity2 = (Double)consumptionFromCommunity.get(consumer.getPodNumber()) + energyNeeded;
                                consumptionFromCommunity.put(consumer.getPodNumber(), newConsumptionFromCommunity2);
                                totalEnergyReceivedPriority += energyNeeded;
                            }
                            continue;
                        }
                        for (Consumer consumer : mapEntryConsumers.getValue()) {
                            energyNeeded = (Double)consumptionFromNetwork.get(consumer.getPodNumber());
                            if (!(d > 0.0)) continue;
                            percentage = energyNeeded / d;
                            energyReceived = totalEnergyAvailable * percentage;
                            newConsumptionFromNetwork = (Double)consumptionFromNetwork.get(consumer.getPodNumber()) - energyReceived;
                            consumptionFromNetwork.put(consumer.getPodNumber(), newConsumptionFromNetwork);
                            newConsumptionFromCommunity = (Double)consumptionFromCommunity.get(consumer.getPodNumber()) + energyReceived;
                            consumptionFromCommunity.put(consumer.getPodNumber(), newConsumptionFromCommunity);
                            totalEnergyReceivedPriority += energyReceived;
                        }
                    }
                    for (Producer nonPriorityProducer : nonPriorityProducers) {
                        d = (Double)productionToNetwork.get(nonPriorityProducer.getPodNumber());
                        if (!(totalEnergyAvailable > 0.0)) continue;
                        double d6 = d / totalEnergyAvailable;
                        energyTransfered = totalEnergyReceivedPriority * d6;
                        double remainingEnergyToNetwork5 = (Double)productionToNetwork.get(nonPriorityProducer.getPodNumber()) - energyTransfered;
                        newProductionToCommunity = (Double)productionToCommunity.get(nonPriorityProducer.getPodNumber()) + energyTransfered;
                        productionToCommunity.put(nonPriorityProducer.getPodNumber(), newProductionToCommunity);
                        productionToNetwork.put(nonPriorityProducer.getPodNumber(), remainingEnergyToNetwork5);
                    }
                    totalEnergyAvailable -= totalEnergyReceivedPriority;
                    double totalEnergyReceivedPercentage = 0.0;
                    for (Consumer consumer : percentageConsumers) {
                        double energyAvailable4;
                        energyNeeded = (Double)consumptionFromNetwork.get(consumer.getPodNumber());
                        if (energyNeeded <= (energyAvailable4 = totalEnergyAvailable * (double)consumer.getPercentage() / 100.0)) {
                            double newConsumptionFromCommunity5 = (Double)consumptionFromCommunity.get(consumer.getPodNumber()) + energyNeeded;
                            consumptionFromCommunity.put(consumer.getPodNumber(), newConsumptionFromCommunity5);
                            consumptionFromNetwork.put(consumer.getPodNumber(), 0.0);
                            totalEnergyReceivedPercentage += energyNeeded;
                            continue;
                        }
                        newConsumptionFromCommunity4 = (Double)consumptionFromCommunity.get(consumer.getPodNumber()) + energyAvailable4;
                        consumptionFromCommunity.put(consumer.getPodNumber(), newConsumptionFromCommunity4);
                        newConsumptionFromNetwork = energyNeeded - energyAvailable4;
                        consumptionFromNetwork.put(consumer.getPodNumber(), newConsumptionFromNetwork);
                        totalEnergyReceivedPercentage += energyAvailable4;
                    }
                    for (Producer producer : nonPriorityProducers) {
                        energyAvailable = (Double)productionToNetwork.get(producer.getPodNumber());
                        if (!(totalEnergyAvailable > 0.0)) continue;
                        percentage = energyAvailable / totalEnergyAvailable;
                        double energyTransfered22 = totalEnergyReceivedPercentage * percentage;
                        remainingEnergyToNetwork = (Double)productionToNetwork.get(producer.getPodNumber()) - energyTransfered22;
                        double newProductionToCommunity22 = (Double)productionToCommunity.get(producer.getPodNumber()) + energyTransfered22;
                        productionToCommunity.put(producer.getPodNumber(), newProductionToCommunity22);
                        productionToNetwork.put(producer.getPodNumber(), remainingEnergyToNetwork);
                    }
                    totalEnergyAvailable -= totalEnergyReceivedPercentage;
                    double d7 = 0.0;
                    if (totalEnergyAvailable > 0.0) {
                        double totalEnergyNeeded3 = 0.0;
                        for (Consumer consumer : consumers) {
                            if (!((Double)consumptionFromNetwork.get(consumer.getPodNumber()) > 0.0) || consumer.getProrata() != 1) continue;
                            totalEnergyNeeded3 += ((Double)consumptionFromNetwork.get(consumer.getPodNumber())).doubleValue();
                        }
                        for (Consumer consumer : consumers) {
                            if (!((Double)consumptionFromNetwork.get(consumer.getPodNumber()) > 0.0) || consumer.getProrata() != 1) continue;
                            double energyNeeded3 = (Double)consumptionFromNetwork.get(consumer.getPodNumber());
                            if (!(totalEnergyNeeded3 > 0.0)) continue;
                            percentage2 = energyNeeded3 / totalEnergyNeeded3;
                            double energyReceived2 = totalEnergyAvailable * percentage2;
                            if (energyReceived2 > energyNeeded3) {
                                double newConsumptionFromCommunity42 = (Double)consumptionFromCommunity.get(consumer.getPodNumber()) + energyNeeded3;
                                consumptionFromCommunity.put(consumer.getPodNumber(), newConsumptionFromCommunity42);
                                consumptionFromNetwork.put(consumer.getPodNumber(), 0.0);
                                d7 += energyNeeded3;
                                continue;
                            }
                            newConsumptionFromCommunity3 = (Double)consumptionFromCommunity.get(consumer.getPodNumber()) + energyReceived2;
                            consumptionFromCommunity.put(consumer.getPodNumber(), newConsumptionFromCommunity3);
                            double newConsumptionFromNetwork4 = (Double)consumptionFromNetwork.get(consumer.getPodNumber()) - energyReceived2;
                            consumptionFromNetwork.put(consumer.getPodNumber(), newConsumptionFromNetwork4);
                            d7 += energyReceived2;
                        }
                        for (Producer nonPriorityProducer : nonPriorityProducers) {
                            double energyAvailable3 = (Double)productionToNetwork.get(nonPriorityProducer.getPodNumber());
                            if (!(totalEnergyAvailable > 0.0)) continue;
                            double percentage3 = energyAvailable3 / totalEnergyAvailable;
                            double energyTransfered3 = d7 * percentage3;
                            double remainingEnergyToNetwork3 = (Double)productionToNetwork.get(nonPriorityProducer.getPodNumber()) - energyTransfered3;
                            double newProductionToCommunity3 = (Double)productionToCommunity.get(nonPriorityProducer.getPodNumber()) + energyTransfered3;
                            productionToCommunity.put(nonPriorityProducer.getPodNumber(), newProductionToCommunity3);
                            productionToNetwork.put(nonPriorityProducer.getPodNumber(), remainingEnergyToNetwork3);
                        }
                    }
                }
            }
            for (Consumer consumer : consumers) {
                DatabaseConnection.addConsumptionDataAfterSharing(new ConsumptionDataAfterSharing(consumer.getPodNumber(), currentDate, currentTime, (Double)consumptionFromCommunity.get(consumer.getPodNumber()), (Double)consumptionFromNetwork.get(consumer.getPodNumber())));
            }
            for (Producer producer : producers) {
                DatabaseConnection.addProductionDataAfterSharing(new ProductionDataAfterSharing(producer.getPodNumber(), currentDate, currentTime, (Double)productionToCommunity.get(producer.getPodNumber()), (Double)productionToNetwork.get(producer.getPodNumber())));
            }
            progressBar.setMaximum(nbRecords);
            progressBar.setSelection(currentRecord);
            ++currentRecord;
        }
        DatabaseConnection.closeTransaction(false);
        progressBar.setVisible(false);
        EnergeticCommunitiesSimulator.updateTables();
        EnergeticCommunitiesSimulator.updateChart();
    }
}

